/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.xpath;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLCDATA;
import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.xpath.FuzzyXMLAttrIterator;
import jp.aonir.fuzzyxml.xpath.FuzzyXMLNodeIterator;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class FuzzyXMLNodePointer
extends NodePointer {
    private Object node;

    public FuzzyXMLNodePointer(NodePointer parent, Object node) {
        super(null);
        this.node = node;
    }

    public FuzzyXMLNodePointer(Object node, Locale locale) {
        super(null, locale);
        this.node = node;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return new FuzzyXMLNodeIterator(this, test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        return new FuzzyXMLAttrIterator(this, name);
    }

    public boolean isLeaf() {
        if (this.node instanceof FuzzyXMLElement) {
            return ((FuzzyXMLElement)this.node).getChildren().length == 0;
        }
        if (this.node instanceof FuzzyXMLDocument) {
            return ((FuzzyXMLDocument)this.node).getDocumentElement() == null;
        }
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public QName getName() {
        String ln = null;
        if (this.node instanceof FuzzyXMLElement) {
            ln = ((FuzzyXMLElement)this.node).getName();
        }
        return new QName(null, ln);
    }

    public Object getBaseValue() {
        return this.node;
    }

    public Object getImmediateNode() {
        return this.node;
    }

    public Object getValue() {
        if (this.node instanceof FuzzyXMLElement) {
            return ((FuzzyXMLElement)this.node).getValue().trim();
        }
        if (this.node instanceof FuzzyXMLComment) {
            return ((FuzzyXMLComment)this.node).getValue();
        }
        if (this.node instanceof FuzzyXMLText) {
            return ((FuzzyXMLText)this.node).getValue();
        }
        if (this.node instanceof FuzzyXMLCDATA) {
            return ((FuzzyXMLCDATA)this.node).getValue();
        }
        if (this.node instanceof FuzzyXMLAttribute) {
            return ((FuzzyXMLAttribute)this.node).getValue();
        }
        return null;
    }

    public void setValue(Object value) {
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        Object node2;
        Object node1 = pointer1.getBaseValue();
        if (node1 == (node2 = pointer2.getBaseValue())) {
            return 0;
        }
        if (node1 instanceof FuzzyXMLAttribute && !(node2 instanceof FuzzyXMLAttribute)) {
            return -1;
        }
        if (!(node1 instanceof FuzzyXMLAttribute) && node2 instanceof FuzzyXMLAttribute) {
            return 1;
        }
        if (node1 instanceof FuzzyXMLAttribute && node2 instanceof FuzzyXMLAttribute) {
            List<FuzzyXMLAttribute> list = Arrays.asList(((FuzzyXMLElement)this.getNode()).getAttributes());
            int length = list.size();
            int i = 0;
            while (i < length) {
                FuzzyXMLAttribute n = list.get(i);
                if (n == node1) {
                    return -1;
                }
                if (n == node2) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        if (!(this.node instanceof FuzzyXMLElement)) {
            throw new RuntimeException("JXPath internal error: compareChildNodes called for " + this.node);
        }
        List<FuzzyXMLNode> children = Arrays.asList(((FuzzyXMLElement)this.node).getChildren());
        int length = children.size();
        int i = 0;
        while (i < length) {
            FuzzyXMLNode n = children.get(i);
            if (n == node1) {
                return -1;
            }
            if (n == node2) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static boolean testNode(NodePointer pointer, Object node, NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            if (!(node instanceof FuzzyXMLElement)) {
                return false;
            }
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            nodeNameTest.getNamespaceURI();
            boolean wildcard = nodeNameTest.isWildcard();
            String testPrefix = testName.getPrefix();
            if (wildcard && testPrefix == null) {
                return true;
            }
            if (wildcard || testName.getName().equals(((FuzzyXMLElement)node).getName())) {
                return true;
            }
        } else if (test instanceof NodeTypeTest) {
            switch (((NodeTypeTest)test).getNodeType()) {
                case 1: {
                    return node instanceof FuzzyXMLElement;
                }
                case 2: {
                    return node instanceof FuzzyXMLText || node instanceof FuzzyXMLCDATA;
                }
                case 3: {
                    return node instanceof FuzzyXMLComment;
                }
            }
            return false;
        }
        return false;
    }
}

