/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import tk.eclipse.plugin.csseditor.editors.CSSConfiguration;
import tk.eclipse.plugin.csseditor.editors.CSSFileDocumentProvider;
import tk.eclipse.plugin.csseditor.editors.CSSOutlinePage;
import tk.eclipse.plugin.csseditor.editors.CSSTextDocumentProvider;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class CSSEditor
extends TextEditor {
    private ColorProvider colorProvider = HTMLPlugin.getDefault().getColorProvider();
    private CSSOutlinePage outline;
    private boolean useSoftTab;
    private String softTab;
    static /* synthetic */ Class class$0;

    public CSSEditor() {
        this.setSourceViewerConfiguration(new CSSConfiguration(this.colorProvider));
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), HTMLPlugin.getDefault().getPreferenceStore()}));
        this.outline = new CSSOutlinePage(this);
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        this.useSoftTab = store.getBoolean("_pref_use_softtab");
        int softTabWidth = store.getInt("_pref_softtab_width");
        this.softTab = "";
        int i = 0;
        while (i < softTabWidth) {
            this.softTab = String.valueOf(this.softTab) + " ";
            ++i;
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input instanceof IStorageEditorInput) {
            this.setDocumentProvider((IDocumentProvider)new CSSFileDocumentProvider());
        } else {
            this.setDocumentProvider((IDocumentProvider)new CSSTextDocumentProvider());
        }
        super.doSetInput(input);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.outline.update();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ISourceViewer viewer = this.getSourceViewer();
        StyledText widget = viewer.getTextWidget();
        widget.setTabs(this.getPreferenceStore().getInt("tabWidth"));
        widget.addVerifyListener((VerifyListener)new SoftTabVerifyListener());
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.outline.update();
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return super.affectsTextPresentation(event) || this.colorProvider.affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.colorProvider.handlePreferenceStoreChanged(event);
        super.handlePreferenceStoreChanged(event);
        String key = event.getProperty();
        if (key.equals("_pref_use_softtab")) {
            this.useSoftTab = (Boolean)event.getNewValue();
        }
        if (key.equals("_pref_softtab_width")) {
            int width = (Integer)event.getNewValue();
            this.softTab = "";
            int i = 0;
            while (i < width) {
                this.softTab = String.valueOf(this.softTab) + " ";
                ++i;
            }
        }
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(HTMLPlugin.getDefault().getResourceBundle(), "ContentAssistProposal", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.outline;
        }
        return super.getAdapter(adapter);
    }

    private class SoftTabVerifyListener
    implements VerifyListener {
        SoftTabVerifyListener() {
        }

        public void verifyText(VerifyEvent evt) {
            if (CSSEditor.this.useSoftTab && evt.text.equals("\t")) {
                evt.text = CSSEditor.this.softTab;
            }
        }
    }
}

