/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.XPath;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class HTMLUtil {
    public static void copyFolder(File from, File to) throws IOException {
        File[] files = from.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                File newDir = new File(to, files[i].getName());
                if (!newDir.exists()) {
                    newDir.mkdir();
                    HTMLUtil.copyFolder(files[i], newDir);
                }
            } else {
                File newFile = new File(to, files[i].getName());
                if (!newFile.exists()) {
                    FileInputStream in = new FileInputStream(files[i]);
                    FileOutputStream out = new FileOutputStream(newFile);
                    byte[] buf = new byte[8216];
                    int length = 0;
                    while ((length = ((InputStream)in).read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, length);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
            }
            ++i;
        }
    }

    public static String escapeHTML(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&quot;");
        return str;
    }

    public static String comment2space(String source, boolean contentsOnly) {
        source = HTMLUtil.jspComment2space(source, contentsOnly);
        source = FuzzyXMLUtil.comment2space((String)source, (boolean)contentsOnly);
        return source;
    }

    public static String jspComment2space(String source, boolean contentsOnly) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("<%--", last)) != -1) {
            int end = source.indexOf("--%>", index);
            if (end == -1) break;
            sb.append(source.substring(last, index));
            int length = end - index + 4;
            if (contentsOnly) {
                sb.append("<%--");
                length -= 8;
            }
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            if (contentsOnly) {
                sb.append("--%>");
            }
            last = end + 4;
        }
        if (last != source.length() - 1) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static String scriptlet2space(String source, boolean contentsOnly) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("<%", last)) != -1) {
            int end = source.indexOf("%>", index);
            if (end == -1) break;
            sb.append(source.substring(last, index));
            int length = end - index + 2;
            if (contentsOnly) {
                sb.append("<%");
                length -= 4;
            }
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            if (contentsOnly) {
                sb.append("%>");
            }
            last = end + 2;
        }
        if (last != source.length() - 1) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static byte[] readStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 0;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        byte[] result = out.toByteArray();
        in.close();
        out.close();
        return result;
    }

    public static String escapeXML(String value) {
        if (value == null) {
            return "";
        }
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("\"", "&quot;");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("'", "&apos;");
        return value;
    }

    public static String getXPathValue(FuzzyXMLElement element, String xpath) {
        try {
            String value = (String)XPath.getValue((FuzzyXMLElement)element, (String)xpath);
            return value.trim();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static FuzzyXMLNode selectXPathNode(FuzzyXMLElement element, String xpath) {
        try {
            return XPath.selectSingleNode((FuzzyXMLElement)element, (String)xpath);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static FuzzyXMLNode[] selectXPathNodes(FuzzyXMLElement element, String xpath) {
        try {
            return XPath.selectNodes((FuzzyXMLElement)element, (String)xpath);
        }
        catch (Exception ex) {
            return new FuzzyXMLNode[0];
        }
    }

    public static String nullConv(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static Document createDocument(InputStream in, EntityResolver resolver) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (resolver != null) {
            builder.setEntityResolver(resolver);
        }
        Document doc = builder.parse(in);
        return doc;
    }

    public static void sortCompilationProposal(ICompletionProposal[] prop) {
        Arrays.sort(prop, new Comparator(){

            public int compare(Object o1, Object o2) {
                ICompletionProposal c1 = (ICompletionProposal)o1;
                ICompletionProposal c2 = (ICompletionProposal)o2;
                return c1.getDisplayString().compareTo(c2.getDisplayString());
            }
        });
    }

    public static String getProjectCharset(IProject project) {
        try {
            String charset = project.getDefaultCharset();
            if (charset.equals("MS932")) {
                charset = "Shift_JIS";
            }
            return charset;
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return null;
        }
    }
}

