/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.assist;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.IFileAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeValueDefinition;
import tk.eclipse.plugin.htmleditor.assist.CSSAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.TagDefinition;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.assist.TextInfo;

public class HTMLAssistProcessor
implements IContentAssistProcessor {
    private char[] chars = new char[0];
    private Image tagImage;
    private Image attrImage;
    private Image valueImage;
    private boolean assistCloseTag = true;
    protected CSSAssistProcessor cssAssist = new CSSAssistProcessor();
    protected IFileAssistProcessor[] fileAssistProcessors;
    private int offset;
    private FuzzyXMLDocument doc;

    public HTMLAssistProcessor() {
        this.tagImage = HTMLPlugin.getDefault().getImageRegistry().get("_icon_tag");
        this.attrImage = HTMLPlugin.getDefault().getImageRegistry().get("_icon_attribute");
        this.valueImage = HTMLPlugin.getDefault().getImageRegistry().get("_icon_value");
        this.fileAssistProcessors = HTMLPlugin.getDefault().getFileAssistProcessors();
    }

    public void setAutoAssistChars(char[] chars) {
        if (chars != null) {
            this.chars = chars;
        }
    }

    public void setAssistCloseTag(boolean assistCloseTag) {
        this.assistCloseTag = assistCloseTag;
    }

    protected AssistInfo[] getAttributeValues(String tagName, String value, AttributeInfo info) {
        if (info.getAttributeType() == 4) {
            return this.cssAssist.getAssistInfo(tagName, value);
        }
        if (info.getAttributeType() == 5) {
            ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
            int i = 0;
            while (i < this.fileAssistProcessors.length) {
                AssistInfo[] assists = this.fileAssistProcessors[i].getAssistInfo(value);
                int j = 0;
                while (j < assists.length) {
                    list.add(assists[j]);
                    ++j;
                }
                ++i;
            }
            return list.toArray(new AssistInfo[list.size()]);
        }
        String[] values = AttributeValueDefinition.getAttributeValues(info.getAttributeType());
        AssistInfo[] infos = new AssistInfo[values.length];
        int i = 0;
        while (i < infos.length) {
            infos[i] = new AssistInfo(values[i]);
            ++i;
        }
        return infos;
    }

    protected List getTagList() {
        return TagDefinition.getTagInfoAsList();
    }

    protected TagInfo getTagInfo(String name) {
        List tagList = TagDefinition.getTagInfoAsList();
        int i = 0;
        while (i < tagList.size()) {
            TagInfo info = (TagInfo)tagList.get(i);
            if (info.getTagName().equals(name)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    protected FuzzyXMLElement getOffsetElement() {
        return this.doc.getElementByOffset(this.offset);
    }

    protected FuzzyXMLDocument getDocument() {
        return this.doc;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        String text = viewer.getDocument().get().substring(0, documentOffset);
        String[] dim = this.getLastWord(text);
        String word = dim[0].toLowerCase();
        String prev = dim[1].toLowerCase();
        String last = dim[2];
        String attr = dim[3];
        this.offset = documentOffset;
        this.doc = new FuzzyXMLParser().parse(viewer.getDocument().get());
        ArrayList<CompletionProposal> list = new ArrayList<CompletionProposal>();
        ArrayList<TagInfo> tagList = this.getTagList();
        if (word.startsWith("\"") && (word.length() == 1 || !word.endsWith("\"")) || word.startsWith("'") && (word.length() == 1 || !word.endsWith("'"))) {
            AttributeInfo attrInfo;
            String value = dim[0].substring(1);
            TagInfo tagInfo = this.getTagInfo(last.toLowerCase());
            if (tagInfo != null && (attrInfo = tagInfo.getAttributeInfo(attr)) != null) {
                AssistInfo[] keywords = this.getAttributeValues(last, dim[0].substring(1), attrInfo);
                int i = 0;
                while (i < keywords.length) {
                    if (keywords[i].getReplaceString().toLowerCase().startsWith(value.toLowerCase())) {
                        list.add(new CompletionProposal(keywords[i].getReplaceString(), documentOffset - value.length(), value.length(), keywords[i].getReplaceString().length(), keywords[i].getImage() == null ? this.valueImage : keywords[i].getImage(), keywords[i].getDisplayString(), null, null));
                    }
                    ++i;
                }
            }
        } else if (word.startsWith("<") && !word.equals("</")) {
            if (this.supportTagRelation()) {
                TagInfo parent = this.getTagInfo(last);
                tagList = new ArrayList<TagInfo>();
                if (parent != null) {
                    String[] childNames = parent.getChildTagNames();
                    int i = 0;
                    while (i < childNames.length) {
                        tagList.add(this.getTagInfo(childNames[i]));
                        ++i;
                    }
                }
            }
            int i = 0;
            while (i < tagList.size()) {
                TagInfo tagInfo = (TagInfo)tagList.get(i);
                if (tagInfo instanceof TextInfo) {
                    TextInfo textInfo = (TextInfo)tagInfo;
                    if (textInfo.getText().toLowerCase().indexOf(word) == 0) {
                        list.add(new CompletionProposal(textInfo.getText(), documentOffset - word.length(), word.length(), textInfo.getPosition(), this.tagImage, textInfo.getDisplayString(), null, null));
                    }
                } else {
                    String tagName = tagInfo.getTagName();
                    if (("<" + tagInfo.getTagName().toLowerCase()).indexOf(word) == 0) {
                        String assistKeyword = tagName;
                        int position = 0;
                        AttributeInfo[] requierAttrs = tagInfo.getRequiredAttributeInfo();
                        int j = 0;
                        while (j < requierAttrs.length) {
                            assistKeyword = String.valueOf(assistKeyword) + " " + requierAttrs[j].getAttributeName();
                            if (requierAttrs[j].hasValue()) {
                                assistKeyword = String.valueOf(assistKeyword) + "=\"\"";
                                if (j == 0) {
                                    position = tagName.length() + requierAttrs[j].getAttributeName().length() + 3;
                                }
                            }
                            ++j;
                        }
                        if (tagInfo.hasBody()) {
                            assistKeyword = String.valueOf(assistKeyword) + ">";
                            if (this.assistCloseTag) {
                                if (position == 0) {
                                    position = assistKeyword.length();
                                }
                                assistKeyword = String.valueOf(assistKeyword) + "</" + tagName + ">";
                            }
                        } else {
                            assistKeyword = String.valueOf(assistKeyword) + "/>";
                        }
                        if (position == 0) {
                            position = assistKeyword.length();
                        }
                        list.add(new CompletionProposal(assistKeyword, documentOffset - word.length() + 1, word.length() - 1, position, this.tagImage, tagName, null, null));
                    }
                }
                ++i;
            }
        } else if (!prev.equals("")) {
            String tagName = prev;
            TagInfo tagInfo = this.getTagInfo(tagName);
            if (tagInfo != null) {
                AttributeInfo[] attrList = tagInfo.getAttributeInfo();
                int j = 0;
                while (j < attrList.length) {
                    if (attrList[j].getAttributeName().toLowerCase().indexOf(word) == 0) {
                        String assistKeyword = null;
                        int position = 0;
                        if (attrList[j].hasValue()) {
                            assistKeyword = String.valueOf(attrList[j].getAttributeName()) + "=\"\"";
                            position = 2;
                        } else {
                            assistKeyword = attrList[j].getAttributeName();
                            position = 0;
                        }
                        list.add(new CompletionProposal(assistKeyword, documentOffset - word.length(), word.length(), attrList[j].getAttributeName().length() + position, this.attrImage, attrList[j].getAttributeName(), null, null));
                    }
                    ++j;
                }
            }
        } else if (!last.equals("")) {
            String assistKeyword = "</" + last + ">";
            int length = 0;
            if (word.equals("</")) {
                length = 2;
            }
            list.add(new CompletionProposal(assistKeyword, documentOffset - length, length, assistKeyword.length(), this.tagImage, assistKeyword, null, null));
        }
        ICompletionProposal[] prop = list.toArray(new ICompletionProposal[list.size()]);
        HTMLUtil.sortCompilationProposal(prop);
        return prop;
    }

    protected boolean supportTagRelation() {
        return false;
    }

    private String[] getLastWord(String text) {
        StringBuffer sb = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        String word = "";
        String prevTag = "";
        String lastTag = "";
        String attr = "";
        String temp1 = "";
        String temp2 = "";
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '<' && text.length() > i + 1 && text.charAt(i + 1) == '%') {
                if ((i = text.indexOf("%>", i + 2)) == -1) {
                    i = text.length();
                }
            } else if (c == '<' && text.length() > i + 1 && text.charAt(i + 1) == '?') {
                if ((i = text.indexOf("?>", i + 2)) == -1) {
                    i = text.length();
                }
            } else if (this.isDelimiter(c)) {
                temp1 = sb.toString();
                if (temp1.length() > 1 && (temp1.startsWith("\"") && !temp1.endsWith("\"") && c != '\"' || temp1.startsWith("'") && !temp1.endsWith("'") && c != '\'')) {
                    sb.append(c);
                } else {
                    if (!temp1.equals("") && (temp2 = temp1).endsWith("=") && !prevTag.equals("") && !temp2.equals("=")) {
                        attr = temp2.substring(0, temp2.length() - 1);
                    }
                    if (temp1.startsWith("<") && !temp1.startsWith("</") && !temp1.startsWith("<!")) {
                        prevTag = temp1.substring(1);
                        if (!temp1.endsWith("/")) {
                            stack.push(prevTag);
                        }
                    } else if (temp1.startsWith("</") && stack.size() != 0) {
                        stack.pop();
                    } else if (temp1.endsWith("/") && stack.size() != 0) {
                        stack.pop();
                    }
                    sb.setLength(0);
                    if (c == '<') {
                        sb.append(c);
                    } else if (c == '\"' || c == '\'') {
                        if (temp1.startsWith("\"") || temp1.startsWith("'")) {
                            sb.append(temp1);
                        }
                        sb.append(c);
                    } else if (c == '>') {
                        prevTag = "";
                        attr = "";
                    }
                }
            } else {
                if (c == '=' && !prevTag.equals("")) {
                    attr = temp2.trim();
                }
                if ((temp1 = sb.toString()).length() > 1 && temp1.startsWith("\"") && temp1.endsWith("\"") || temp1.startsWith("'") && temp1.endsWith("'")) {
                    sb.setLength(0);
                }
                sb.append(c);
            }
            ++i;
        }
        if (stack.size() != 0) {
            lastTag = (String)stack.pop();
        }
        if (attr.endsWith("=")) {
            attr = attr.substring(0, attr.length() - 1);
        }
        word = sb.toString();
        return new String[]{word, prevTag, lastTag, attr};
    }

    private boolean isDelimiter(char c) {
        return c == ' ' || c == '(' || c == ')' || c == ',' || c == ';' || c == '\n' || c == '\r' || c == '\t' || c == '+' || c == '>' || c == '<' || c == '*' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '\'';
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        ContextInformation[] info = new ContextInformation[]{};
        return info;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.chars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.chars;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    public String getErrorMessage() {
        return "Error";
    }

    public void update(IFileEditorInput input, String source) {
        this.cssAssist.reload(input.getFile(), source);
        int i = 0;
        while (i < this.fileAssistProcessors.length) {
            this.fileAssistProcessors[i].reload(input.getFile());
            ++i;
        }
    }
}

