/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditor;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;

public class HTMLOutlinePage
extends ContentOutlinePage
implements IHTMLOutlinePage {
    private RootNode root;
    private HTMLSourceEditor editor;
    private FuzzyXMLDocument doc;

    public HTMLOutlinePage(HTMLSourceEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        this.root = new RootNode();
        viewer.setContentProvider((IContentProvider)new HTMLContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new HTMLLabelProvider());
        viewer.setInput((Object)this.root);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new HTMLSelectionChangedListener());
        try {
            viewer.setExpandedState(this.root.getChildren()[0], true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
    }

    public void update() {
        this.doc = new FuzzyXMLParser().parse(this.editor.getHTMLSource());
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            viewer.refresh();
        }
    }

    private class RootNode {
        public Object[] getChildren() {
            ArrayList<FuzzyXMLNode> children = new ArrayList<FuzzyXMLNode>();
            FuzzyXMLNode[] nodes = HTMLOutlinePage.this.doc.getDocumentElement().getChildren();
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] instanceof FuzzyXMLElement) {
                    children.add(nodes[i]);
                }
                ++i;
            }
            return children.toArray(new FuzzyXMLElement[children.size()]);
        }

        public boolean equals(Object obj) {
            return obj instanceof RootNode;
        }
    }

    private class HTMLContentProvider
    implements ITreeContentProvider {
        HTMLContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RootNode) {
                return ((RootNode)parentElement).getChildren();
            }
            if (parentElement instanceof FuzzyXMLElement) {
                ArrayList<FuzzyXMLNode> children = new ArrayList<FuzzyXMLNode>();
                FuzzyXMLNode[] nodes = ((FuzzyXMLElement)parentElement).getChildren();
                int i = 0;
                while (i < nodes.length) {
                    if (nodes[i] instanceof FuzzyXMLElement) {
                        children.add(nodes[i]);
                    }
                    ++i;
                }
                return children.toArray(new FuzzyXMLElement[children.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof FuzzyXMLElement) {
                FuzzyXMLNode parent = ((FuzzyXMLElement)element).getParentNode();
                if (parent == null) {
                    return HTMLOutlinePage.this.root.getChildren()[0];
                }
                return parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class HTMLLabelProvider
    extends LabelProvider {
        HTMLLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof FuzzyXMLElement) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_tag");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof FuzzyXMLElement) {
                StringBuffer sb = new StringBuffer();
                FuzzyXMLAttribute[] attrs = ((FuzzyXMLElement)element).getAttributes();
                int i = 0;
                while (i < attrs.length) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(String.valueOf(attrs[i].getName()) + "=" + attrs[i].getValue());
                    ++i;
                }
                if (sb.length() == 0) {
                    return ((FuzzyXMLElement)element).getName();
                }
                return String.valueOf(((FuzzyXMLElement)element).getName()) + "(" + sb.toString() + ")";
            }
            return super.getText(element);
        }
    }

    private class HTMLSelectionChangedListener
    implements ISelectionChangedListener {
        HTMLSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object element = sel.getFirstElement();
            if (element instanceof FuzzyXMLElement) {
                int offset = ((FuzzyXMLElement)element).getOffset();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart instanceof HTMLEditor) {
                    ((HTMLEditor)editorPart).setOffset(offset);
                }
            }
        }
    }
}

