/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.editors.URLEditorInput;

public class WebBrowser
extends EditorPart {
    private Text textUrl;
    private Browser browser;
    private ToolItem buttonRun;
    private ToolItem buttonForward;
    private ToolItem buttonBackword;
    private ToolItem buttonRefresh;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput) && !(input instanceof URLEditorInput)) {
            throw new PartInitException("Web browser allows only IFileEditorInput or URLEditorInput.");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void setInput(IEditorInput input) {
        String url;
        super.setInput(input);
        if (input instanceof IFileEditorInput) {
            if (this.browser != null) {
                IFile file = ((IFileEditorInput)input).getFile();
                if (file.getName().endsWith(".url")) {
                    try {
                        String source = new String(HTMLUtil.readStream(file.getContents()));
                        String[] dim = source.split("(\r\n|\r|\n)");
                        int i = 0;
                        while (i < dim.length) {
                            if (dim[i].startsWith("URL=")) {
                                String url2 = dim[i].substring(4, dim[i].length()).trim();
                                this.textUrl.setText(url2);
                                this.browser.setUrl(url2);
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        HTMLPlugin.logException(ex);
                    }
                } else {
                    String url3 = "file://" + file.getLocation().makeAbsolute().toFile().getAbsolutePath().replaceAll("\\\\", "/");
                    this.textUrl.setText(url3);
                    this.browser.setUrl(url3);
                }
            }
        } else if (input instanceof URLEditorInput && this.browser != null && (url = ((URLEditorInput)input).getUrl()) != null && !url.equals("")) {
            this.textUrl.setText(url);
            this.browser.setUrl(url);
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Composite northPane = new Composite(composite, 0);
        GridLayout northPaneLayout = new GridLayout(2, false);
        northPaneLayout.marginHeight = 0;
        northPaneLayout.marginWidth = 0;
        northPane.setLayout((Layout)northPaneLayout);
        northPane.setLayoutData((Object)new GridData(768));
        this.textUrl = new Text(northPane, 2048);
        this.textUrl.setLayoutData((Object)new GridData(768));
        this.textUrl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    WebBrowser.this.browser.setUrl(WebBrowser.this.textUrl.getText());
                }
            }
        });
        ToolBar toolbar = new ToolBar(northPane, 0x800000);
        this.buttonRun = new ToolItem(toolbar, 8);
        this.buttonRun.setImage(HTMLPlugin.getDefault().getImageRegistry().get("_icon_run"));
        this.buttonRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WebBrowser.this.browser.setUrl(WebBrowser.this.textUrl.getText());
            }
        });
        this.buttonRefresh = new ToolItem(toolbar, 8);
        this.buttonRefresh.setImage(HTMLPlugin.getDefault().getImageRegistry().get("_icon_refresh"));
        this.buttonRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WebBrowser.this.browser.refresh();
            }
        });
        this.buttonBackword = new ToolItem(toolbar, 8);
        this.buttonBackword.setImage(HTMLPlugin.getDefault().getImageRegistry().get("_icon_backword"));
        this.buttonBackword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WebBrowser.this.browser.back();
            }
        });
        this.buttonForward = new ToolItem(toolbar, 8);
        this.buttonForward.setImage(HTMLPlugin.getDefault().getImageRegistry().get("_icon_forward"));
        this.buttonForward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WebBrowser.this.browser.forward();
            }
        });
        this.browser = new Browser(composite, 0);
        this.browser.setLayoutData((Object)new GridData(1808));
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                try {
                    URLEditorInput input = new URLEditorInput(null);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = window.getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"tk.eclipse.plugin.htmleditor.editors.WebBrowser");
                    IEditorPart editorPart = page.getActiveEditor();
                    if (editorPart instanceof WebBrowser) {
                        event.browser = ((WebBrowser)editorPart).getBrowser();
                    }
                }
                catch (PartInitException ex) {
                    HTMLPlugin.logException(ex);
                }
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                WebBrowser.this.setPartName(event.title);
                WebBrowser.this.textUrl.setText(WebBrowser.this.browser.getUrl());
                WebBrowser.this.refreshActions();
            }
        });
        this.setInput(this.getEditorInput());
    }

    private void refreshActions() {
        this.buttonBackword.setEnabled(this.browser.isBackEnabled());
        this.buttonForward.setEnabled(this.browser.isForwardEnabled());
    }

    public void setFocus() {
        this.browser.setFocus();
    }
}

