/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class HTMLNewWizardPage
extends WizardNewFileCreationPage {
    private Text titleText;
    private Combo comboDocType;
    private static DocType[] docTypes = new DocType[]{new DocType("", null, null), new DocType("HTML 4.01 Strict", "-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd"), new DocType("HTML 4.01 Transitional", "-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd"), new DocType("HTML 4.01 Frameset", "-//W3C//DTD HTML 4.01 Frameset//EN", "http://www.w3.org/TR/html4/frameset.dtd")};

    public HTMLNewWizardPage(ISelection selection) {
        super("wizardPage", (IStructuredSelection)selection);
        this.setTitle(HTMLPlugin.getResourceString("HTMLNewWizardPage.Title"));
        this.setDescription(HTMLPlugin.getResourceString("HTMLNewWizardPage.Description"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName("newfile.html");
        Composite container = new Composite((Composite)this.getControl(), 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        container.setLayoutData((Object)new GridData(768));
        Label label = new Label(container, 0);
        label.setText(HTMLPlugin.getResourceString("HTMLNewWizardPage.InputTitle"));
        this.titleText = new Text(container, 2052);
        this.titleText.setLayoutData((Object)new GridData(768));
        label = new Label(container, 0);
        label.setText(HTMLPlugin.getResourceString("HTMLNewWizardPage.InputDocType"));
        this.comboDocType = new Combo(container, 8);
        int i = 0;
        while (i < docTypes.length) {
            this.comboDocType.add(HTMLNewWizardPage.docTypes[i].label);
            ++i;
        }
    }

    protected InputStream getInitialContents() {
        int i = this.comboDocType.getSelectionIndex();
        if (i < 0) {
            i = 0;
        }
        DocType docType = docTypes[i];
        String projectName = this.getContainerFullPath().segment(0);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String charset = HTMLUtil.getProjectCharset(project);
        StringBuffer sb = new StringBuffer();
        if (!docType.label.equals("") && docType.format != null && !docType.format.equals("")) {
            sb.append("<!DOCTYPE HTML PUBLIC \"" + docType.format + "\"");
            if (docType.dtd != null && !docType.dtd.equals("")) {
                sb.append(" \"" + docType.dtd + "\"");
            }
            sb.append(">\n");
        }
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html");
        if (charset != null) {
            sb.append("; charset=" + charset);
        }
        sb.append("\"/>\n");
        sb.append("<title>" + HTMLUtil.escapeHTML(this.titleText.getText()) + "</title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private static class DocType {
        public String label;
        public String format;
        public String dtd;

        public DocType(String label, String format, String dtd) {
            this.label = label;
            this.format = format;
            this.dtd = dtd;
        }
    }
}

