/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;

public class JSPInfo {
    private ArrayList tldInfoList = new ArrayList();
    private Pattern taglibPattern = Pattern.compile("<%@\\s*taglib\\s+(.+?)%>", 32);
    private Pattern uriPattern = Pattern.compile("uri\\s*=\\s*\"(.+?)\"");
    private Pattern tagdirPattern = Pattern.compile("tagdir\\s*=\\s*\"(.+?)\"");
    private Pattern prefixPattern = Pattern.compile("prefix\\s*=\\s*\"(.+?)\"");
    private Pattern includePattern = Pattern.compile("<%@\\s*include\\s+(.+?)%>", 32);
    private Pattern filePattern = Pattern.compile("file\\s*=\\s*\"(.+?)\"");

    public JSPInfo(IFile file, String source) {
        this(file, source, true);
    }

    public JSPInfo(IFile file, String source, boolean include) {
        try {
            Object info;
            String content;
            HTMLProjectParams params = new HTMLProjectParams(file.getProject());
            String webapproot = params.getRoot();
            IProject basedir = file.getProject();
            if (!webapproot.equals("") && !webapproot.equals("/")) {
                basedir = basedir.getFolder((IPath)new Path(webapproot));
            }
            Matcher matcher = this.includePattern.matcher(source);
            while (matcher.find()) {
                content = matcher.group(1);
                String fileInc = this.getAttribute(content, this.filePattern);
                if (fileInc == null) continue;
                IFile incJspFile = null;
                incJspFile = fileInc.startsWith("/") ? basedir.getFile((IPath)new Path(fileInc)) : file.getParent().getFile((IPath)new Path(fileInc));
                try {
                    if (incJspFile == null || !incJspFile.exists()) continue;
                    String contents = new String(HTMLUtil.readStream(incJspFile.getContents()));
                    info = new JSPInfo(incJspFile, contents);
                    TLDInfo[] tldInfos = ((JSPInfo)info).getTLDInfo();
                    int i = 0;
                    while (i < tldInfos.length) {
                        this.tldInfoList.add(tldInfos[i]);
                        ++i;
                    }
                }
                catch (IOException ioe) {
                    HTMLPlugin.logException(ioe);
                }
                catch (CoreException ce) {
                    HTMLPlugin.logException(ce);
                }
            }
            matcher = this.taglibPattern.matcher(source);
            while (matcher.find()) {
                content = matcher.group(1);
                String tagdir = this.getAttribute(content, this.tagdirPattern);
                if (tagdir != null) {
                    String prefix = this.getAttribute(content, this.prefixPattern);
                    TLDInfo info2 = TLDInfo.getTLDInfoFromTagdir(file, prefix, tagdir);
                    if (info2 == null) continue;
                    this.tldInfoList.add(info2);
                    continue;
                }
                String uri = this.getAttribute(content, this.uriPattern);
                String prefix = this.getAttribute(content, this.prefixPattern);
                info = TLDInfo.getTLDInfo(file, prefix, uri);
                if (info == null) continue;
                this.tldInfoList.add(info);
            }
            try {
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(HTMLUtil.scriptlet2space(source, false));
                FuzzyXMLElement root = (FuzzyXMLElement)XPath.selectSingleNode((FuzzyXMLElement)doc.getDocumentElement(), (String)"*");
                if (root != null) {
                    FuzzyXMLAttribute[] attrs = root.getAttributes();
                    int i = 0;
                    while (i < attrs.length) {
                        TLDInfo info3;
                        String[] dim;
                        if (attrs[i].getName().startsWith("xmlns:") && (dim = attrs[i].getName().split(":")).length > 1 && (info3 = TLDInfo.getTLDInfo(file, dim[1], attrs[i].getValue())) != null) {
                            this.tldInfoList.add(info3);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
            try {
                if (include) {
                    IPath path = new Path(webapproot).append("/WEB-INF/web.xml");
                    IFile webXML = file.getProject().getFile(path);
                    if (webXML != null && webXML.exists()) {
                        FuzzyXMLDocument doc = new FuzzyXMLParser().parse(webXML.getContents());
                        FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes(doc.getDocumentElement(), "/web-app/jsp-config/jsp-property-group[url-pattern='*.jsp']");
                        int i = 0;
                        while (i < nodes.length) {
                            FuzzyXMLNode[] includes = HTMLUtil.selectXPathNodes((FuzzyXMLElement)nodes[i], "/include-prelude|/include-coda");
                            int j = 0;
                            while (j < includes.length) {
                                IFile incFile = basedir.getFile((IPath)new Path(((FuzzyXMLElement)includes[j]).getValue()));
                                if (incFile != null && incFile.exists()) {
                                    String contents = new String(HTMLUtil.readStream(incFile.getContents()));
                                    JSPInfo info4 = new JSPInfo(incFile, contents, false);
                                    TLDInfo[] tldInfos = info4.getTLDInfo();
                                    int k = 0;
                                    while (k < tldInfos.length) {
                                        this.tldInfoList.add(tldInfos[k]);
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        catch (CoreException ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private String getAttribute(String source, Pattern pattern) {
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getTaglibUri(String prefix) {
        String uri = null;
        TLDInfo[] tlds = this.getTLDInfo();
        int i = 0;
        while (i < tlds.length) {
            if (tlds[i].getPrefix().equals(prefix)) {
                uri = tlds[i].getTaglibUri();
                break;
            }
            ++i;
        }
        return uri;
    }

    public TLDInfo[] getTLDInfo() {
        return this.tldInfoList.toArray(new TLDInfo[this.tldInfoList.size()]);
    }
}

