/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.ICustomTagConverter;
import tk.eclipse.plugin.htmleditor.ICustomTagConverterContributer;
import tk.eclipse.plugin.jspeditor.editors.JSPInfo;

public class JSPPreviewConverter {
    private static Pattern petternScript = Pattern.compile("<%(.*?)%>", 32);
    private static Pattern petternTagBegin = Pattern.compile("<(|/)((\\w+?):(.*?))>");

    public static String convertJSP(IFileEditorInput input, String jsp) {
        JSPInfo info = new JSPInfo(input.getFile(), jsp);
        String lower = (jsp = HTMLUtil.comment2space(jsp, false)).toLowerCase();
        int index = lower.indexOf("<body");
        if (index == -1) {
            jsp = petternScript.matcher(jsp).replaceAll("");
            jsp = petternTagBegin.matcher(jsp).replaceAll("");
            return jsp;
        }
        String head = jsp.substring(0, index);
        String body = jsp.substring(index, jsp.length());
        head = petternScript.matcher(head).replaceAll("");
        head = petternTagBegin.matcher(head).replaceAll("");
        body = JSPPreviewConverter.processScript(body);
        body = JSPPreviewConverter.processTag(body, info);
        body = body.replaceAll("&amp;nbsp;", "&nbsp;");
        body = body.replaceAll("&apos;", "'");
        return String.valueOf(head) + body + "</html>";
    }

    private static String processScript(String jsp) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = petternScript.matcher(jsp);
        int index = 0;
        while (matcher.find()) {
            sb.append(jsp.substring(index, matcher.start()));
            sb.append(HTMLUtil.escapeHTML(matcher.group(0)));
            index = matcher.end();
        }
        if (index < jsp.length() - 1) {
            sb.append(jsp.substring(index));
        }
        return sb.toString();
    }

    public static String processElement(FuzzyXMLElement element, JSPInfo info) {
        StringBuffer sb = new StringBuffer();
        if (element.getName().indexOf(":") != -1) {
            ICustomTagConverterContributer contributer;
            String tagName = element.getName();
            String[] dim = tagName.split(":");
            String uri = info.getTaglibUri(dim[0]);
            ICustomTagConverter converter = null;
            if (uri != null && (contributer = HTMLPlugin.getDefault().getCustomTagContributer(uri)) != null) {
                converter = contributer.getConverter(dim[1]);
            }
            if (converter != null) {
                HashMap<String, String> attrMap = new HashMap<String, String>();
                FuzzyXMLAttribute[] attrs = element.getAttributes();
                int i = 0;
                while (i < attrs.length) {
                    attrMap.put(attrs[i].getName(), attrs[i].getValue());
                    ++i;
                }
                sb.append(converter.process(attrMap, element.getChildren(), info));
                return sb.toString();
            }
        }
        if (element.getChildren().length == 0) {
            sb.append(element.toXMLString());
        } else {
            sb.append(JSPPreviewConverter.element2startTag(element));
            FuzzyXMLNode[] node = element.getChildren();
            int i = 0;
            while (i < node.length) {
                if (node[i] instanceof FuzzyXMLElement) {
                    sb.append(JSPPreviewConverter.processElement((FuzzyXMLElement)node[i], info));
                } else {
                    sb.append(node[i].toXMLString());
                }
                ++i;
            }
            sb.append(JSPPreviewConverter.element2closeTag(element));
        }
        return sb.toString();
    }

    private static String element2startTag(FuzzyXMLElement e) {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + e.getName());
        FuzzyXMLAttribute[] attr = e.getAttributes();
        int i = 0;
        while (i < attr.length) {
            sb.append(" " + attr[i].getName() + "=\"" + attr[i].getValue() + "\"");
            ++i;
        }
        sb.append(">");
        return sb.toString();
    }

    private static String element2closeTag(FuzzyXMLElement e) {
        return "</" + e.getName() + ">";
    }

    private static String processTag(String jsp, JSPInfo info) {
        FuzzyXMLDocument doc = new FuzzyXMLParser().parse(jsp);
        FuzzyXMLNode[] nodes = doc.getDocumentElement().getChildren();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof FuzzyXMLElement) {
                sb.append(JSPPreviewConverter.processElement((FuzzyXMLElement)nodes[i], info));
            }
            ++i;
        }
        return sb.toString();
    }
}

