/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.jspeditor.editors.TLDLoader;
import tk.eclipse.plugin.jspeditor.editors.TLDResolver;
import tk.eclipse.plugin.jspeditor.editors.TLDSAXHandler;

public class TLDInfo {
    private String prefix;
    private String uri;
    private String taglibUri;
    private List tagInfoList = new ArrayList();
    private static HashMap cache = new HashMap();

    public static TLDInfo getTLDInfoFromTagdir(IFile file, String prefix, String tagdir) {
        return new TLDInfo(prefix);
    }

    public static TLDInfo getTLDInfo(IFile file, String prefix, String uri) {
        if (cache.get(uri) != null) {
            return (TLDInfo)cache.get(uri);
        }
        try {
            return new TLDInfo(file, prefix, uri);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private TLDInfo(String prefix) {
        this.prefix = prefix;
    }

    private TLDInfo(IFile file, String prefix, String uri) throws Exception {
        this.prefix = prefix;
        this.uri = uri;
        HTMLProjectParams params = new HTMLProjectParams(file.getProject());
        String root = params.getRoot();
        Object basedir = null;
        basedir = root.equals("") || root.equals("/") ? file.getProject() : file.getProject().getFolder((IPath)new Path(root));
        InputStream in = TLDLoader.get(basedir.getLocation().makeAbsolute().toFile(), uri);
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        spfactory.setValidating(false);
        SAXParser parser = spfactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        TLDSAXHandler handler = new TLDSAXHandler(this.prefix);
        reader.setEntityResolver(new TLDResolver());
        reader.setContentHandler(handler);
        reader.parse(new InputSource(in));
        this.tagInfoList = handler.getResult();
        this.taglibUri = handler.getUri();
        cache.put(this, uri);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public String getTaglibUri() {
        return this.taglibUri;
    }

    public List getTagInfo() {
        return this.tagInfoList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[TLDInfo]");
        sb.append(" uri=").append(this.getUri());
        sb.append(" prefix=").append(this.getPrefix());
        return sb.toString();
    }
}

