/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;

public class TLDSAXHandler
extends DefaultHandler {
    private int mode = 0;
    private String prevTag = null;
    private boolean hasBody = true;
    private ArrayList attributes = new ArrayList();
    private HashMap required = new HashMap();
    private String uri = null;
    private StringBuffer tagName = new StringBuffer();
    private StringBuffer attrName = new StringBuffer();
    private String prefix = "";
    private ArrayList result = new ArrayList();

    public TLDSAXHandler(String prefix) {
        this.prefix = prefix;
    }

    public TLDSAXHandler() {
        this.prefix = null;
    }

    public String getUri() {
        return this.uri;
    }

    public List getResult() {
        return this.result;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("tag")) {
            this.mode = 1;
        } else if (qName.equals("attribute")) {
            this.mode = 2;
        }
        this.prevTag = qName;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("tag")) {
            TagInfo info = new TagInfo(this.tagName.toString(), this.hasBody);
            int i = 0;
            while (i < this.attributes.size()) {
                String attrName = (String)this.attributes.get(i);
                boolean required = false;
                if (this.required.get(attrName) != null) {
                    required = true;
                }
                info.addAttributeInfo(new AttributeInfo(attrName, true, 0, required));
                ++i;
            }
            this.result.add(info);
            this.mode = 0;
            this.prevTag = null;
            this.hasBody = true;
            this.required.clear();
            this.tagName.setLength(0);
            this.attributes.clear();
        } else if (qName.equals("name") && this.mode == 2) {
            this.attributes.add(this.attrName.toString());
            this.attrName.setLength(0);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < start + length) {
            sb.append(ch[i]);
            ++i;
        }
        String value = sb.toString().trim();
        if (!value.equals("")) {
            if (this.prevTag.equals("name")) {
                if (this.mode == 1) {
                    if (this.tagName.length() == 0) {
                        this.tagName.append(String.valueOf(this.prefix) + ":");
                    }
                    this.tagName.append(value);
                } else {
                    this.attrName.append(value);
                }
            } else if (this.prevTag.equals("bodycontent")) {
                this.hasBody = !value.equals("empty");
            } else if (this.prevTag.equals("required")) {
                if (value.equals("true")) {
                    this.required.put(this.attributes.get(this.attributes.size() - 1), "true");
                }
            } else if (this.prevTag.equals("uri")) {
                this.uri = value;
            } else if (this.prefix == null && this.prevTag.equals("shortname")) {
                this.prefix = value;
            }
        }
    }
}

