/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.xmleditor.editors.IDTDResolver;

public class DTDResolver
implements EntityResolver {
    private HashMap map = new HashMap();
    private IDTDResolver[] resolvers = null;

    public DTDResolver(IDTDResolver[] resolvers) {
        this.resolvers = resolvers;
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String[] uri = store.getString("_pref_dtd_uri").split("\n");
        String[] path = store.getString("_pref_dtd_path").split("\n");
        int i = 0;
        while (i < uri.length) {
            if (!uri[i].trim().equals("") && !path[i].trim().equals("")) {
                this.map.put(uri[i].trim(), path[i].trim());
            }
            ++i;
        }
    }

    public InputStream getInputStream(String url) {
        Map innerDTD;
        File file;
        InputStream in = null;
        int i = 0;
        while (i < this.resolvers.length) {
            in = this.resolvers[i].getInputStream(url);
            if (in != null) {
                return in;
            }
            ++i;
        }
        String path = (String)this.map.get(url);
        if (path != null && (file = new File(path)).exists() && file.isFile()) {
            try {
                return new FileInputStream(file);
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        if ((innerDTD = HTMLPlugin.getInnerDTD()).get(url) != null) {
            return this.getClass().getResourceAsStream((String)innerDTD.get(url));
        }
        if (url.indexOf(47) >= 0 && (url.endsWith(".xsd") || url.endsWith(".dtd")) && (in = this.getInputStream(url.substring(url.lastIndexOf(47) + 1))) != null) {
            return in;
        }
        try {
            return this.getStreamFromURL(url);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private InputStream getStreamFromURL(String url) {
        File cacheDir;
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        if (!store.getBoolean("_pref_dtd_cache")) {
            try {
                return new URL(url).openStream();
            }
            catch (Exception exception) {
                return null;
            }
        }
        String name = url.substring(url.lastIndexOf("/") + 1);
        if (name.indexOf("\\") > 0) {
            name = name.substring(name.lastIndexOf("\\") + 1);
        }
        if (!(cacheDir = new File(Platform.getPluginStateLocation((Plugin)HTMLPlugin.getDefault()).toFile(), "dtd")).exists() || !cacheDir.isDirectory()) {
            cacheDir.mkdirs();
        }
        File cacheFile = new File(cacheDir, name);
        try {
            InputStream in = new URL(url).openStream();
            byte[] buf = HTMLUtil.readStream(in);
            FileOutputStream out = new FileOutputStream(cacheFile);
            out.write(buf);
            out.close();
            in.close();
            String uri = store.getString("_pref_dtd_uri");
            String path = store.getString("_pref_dtd_path");
            store.setValue("_pref_dtd_uri", String.valueOf(uri) + "\n" + url);
            store.setValue("_pref_dtd_path", String.valueOf(path) + "\n" + cacheFile.getAbsolutePath());
            HTMLPlugin.getDefault().savePluginPreferences();
            return new ByteArrayInputStream(buf);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream in;
        if (systemId != null && (in = this.getInputStream(systemId)) != null) {
            return new InputSource(in);
        }
        return null;
    }
}

