/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IFileEditorInput;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.DTDResolver;
import tk.eclipse.plugin.xmleditor.editors.IDTDResolver;
import tk.eclipse.plugin.xmleditor.editors.SchemaGenerator;
import tk.eclipse.plugin.xmleditor.editors.XMLAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLConfiguration;
import tk.eclipse.plugin.xmleditor.editors.XMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.XMLValidationHandler;

public class XMLEditor
extends HTMLSourceEditor {
    private boolean validation = true;
    private ArrayList resolvers = new ArrayList();
    public static final String GROUP_XML = "_xml";
    public static final String ACTION_GEN_DTD = "_generate_dtd";
    public static final String ACTION_GEN_XSD = "_generate_xsd";
    private Pattern patternDoctypePublic = Pattern.compile("<!DOCTYPE.+?PUBLIC(\\s|\r|\n)*?\"(.+?)\"(\\s|\r|\n)*?\"(.+?)\"", 32);
    private Pattern patternDoctypeSystem = Pattern.compile("<!DOCTYPE.+?SYSTEM(\\s|\r|\n)*?\"(.+?)\"", 32);
    private Pattern patternNsXSD = Pattern.compile("schemaLocation(\\s|\r|\n)*?=(\\s|\r|\n)*?\"(.+?)\"", 32);
    private Pattern patternNoNsXSD = Pattern.compile("noNamespaceSchemaLocation(\\s|\r|\n)*?=(\\s|\r|\n)*?\"(.+?)\"", 32);

    public XMLEditor() {
        this(new XMLConfiguration(HTMLPlugin.getDefault().getColorProvider()));
    }

    public XMLEditor(XMLConfiguration config) {
        super(config);
        this.setAction(ACTION_GEN_DTD, (IAction)new GenerateDTDAction());
        this.setAction(ACTION_GEN_XSD, (IAction)new GenerateXSDAction());
    }

    protected IHTMLOutlinePage createOutlinePage() {
        return new XMLOutlinePage(this);
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public boolean getValidation() {
        return this.validation;
    }

    public void addDTDResolver(IDTDResolver resolver) {
        this.resolvers.add(resolver);
    }

    public IDTDResolver[] getDTDResolvers() {
        return this.resolvers.toArray(new IDTDResolver[this.resolvers.size()]);
    }

    protected void doValidate() {
        if (!this.validation) {
            return;
        }
        if (!this.isFileEditorInput()) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFileEditorInput input = (IFileEditorInput)XMLEditor.this.getEditorInput();
                        String xml = XMLEditor.this.getDocumentProvider().getDocument((Object)input).get();
                        IFile resource = input.getFile();
                        HTMLProjectParams params = new HTMLProjectParams(resource.getProject());
                        if (!params.getUseDTD()) {
                            Matcher matcher = XMLEditor.this.patternDoctypePublic.matcher(xml);
                            if (matcher.find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                            if ((matcher = XMLEditor.this.patternDoctypeSystem.matcher(xml)).find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                        }
                        SAXParser parser = new SAXParser();
                        String dtd = XMLEditor.this.getDTD(xml);
                        String[] xsd = XMLEditor.this.getXSD(xml);
                        if (dtd == null && xsd == null || !params.getUseDTD()) {
                            parser.setFeature("http://xml.org/sax/features/validation", false);
                        } else {
                            parser.setFeature("http://xml.org/sax/features/validation", true);
                        }
                        if (xsd != null && params.getUseDTD()) {
                            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                            parser.setFeature("http://xml.org/sax/features/namespaces", true);
                        }
                        parser.setEntityResolver((EntityResolver)new DTDResolver(XMLEditor.this.getDTDResolvers()));
                        parser.setErrorHandler((ErrorHandler)new XMLValidationHandler((IResource)resource));
                        parser.parse(new InputSource(new StringReader(xml)));
                    }
                    catch (Exception ex) {
                        HTMLPlugin.logException(ex);
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private String removeMatched(String source, int start, int end) {
        StringBuffer sb = new StringBuffer();
        sb.append(source.substring(0, start));
        int i = start;
        while (i < end + 1) {
            char c = source.charAt(i);
            if (c == '\r' || c == '\n') {
                sb.append(c);
            } else {
                sb.append(" ");
            }
            ++i;
        }
        sb.append(source.substring(end + 1, source.length()));
        return sb.toString();
    }

    public String getDTD(String xml) {
        Matcher matcher = this.patternDoctypePublic.matcher(xml);
        if (matcher.find()) {
            return matcher.group(4);
        }
        matcher = this.patternDoctypeSystem.matcher(xml);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    public String[] getXSD(String xml) {
        Matcher matcher = this.patternNsXSD.matcher(xml);
        if (matcher.find()) {
            String matched = matcher.group(3).trim();
            matched.replaceAll("\r\n", "\n");
            matched.replaceAll("\r", "\n");
            String[] xsd = matched.split("\n| |\t");
            int i = 0;
            while (i < xsd.length) {
                xsd[i] = xsd[i].trim();
                ++i;
            }
            return xsd;
        }
        matcher = this.patternNoNsXSD.matcher(xml);
        if (matcher.find()) {
            return new String[]{matcher.group(3).trim()};
        }
        return null;
    }

    protected void updateAssist() {
        try {
            String[] xsd;
            DTDResolver resolver;
            InputStream in;
            if (!this.isFileEditorInput()) {
                return;
            }
            super.updateAssist();
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            HTMLProjectParams params = new HTMLProjectParams(input.getFile().getProject());
            if (!params.getUseDTD()) {
                return;
            }
            String xml = this.getDocumentProvider().getDocument((Object)input).get();
            String dtd = this.getDTD(xml);
            if (dtd != null && (in = (resolver = new DTDResolver(this.getDTDResolvers())).getInputStream(dtd)) != null) {
                InputStreamReader reader = new InputStreamReader(in);
                XMLAssistProcessor assistProcessor = (XMLAssistProcessor)((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
                assistProcessor.updateDTDInfo(reader);
                ((Reader)reader).close();
            }
            if ((xsd = this.getXSD(xml)) != null) {
                DTDResolver resolver2 = new DTDResolver(this.getDTDResolvers());
                int i = 0;
                while (i < xsd.length) {
                    InputStream in2 = resolver2.getInputStream(xsd[i]);
                    if (in2 != null) {
                        InputStreamReader reader = new InputStreamReader(in2);
                        XMLAssistProcessor assistProcessor = (XMLAssistProcessor)((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
                        assistProcessor.updateXSDInfo(xsd[i], reader);
                        ((Reader)reader).close();
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator(GROUP_XML));
        this.addAction(menu, GROUP_XML, ACTION_GEN_DTD);
        this.addAction(menu, GROUP_XML, ACTION_GEN_XSD);
    }

    private class GenerateDTDAction
    extends Action {
        public GenerateDTDAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.GenerateDTD"));
        }

        public void run() {
            FileDialog dialog = new FileDialog(XMLEditor.this.getViewer().getTextWidget().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.dtd"});
            String file = dialog.open();
            if (file != null) {
                try {
                    SchemaGenerator.generateDTD(XMLEditor.this.getFile(), new File(file));
                }
                catch (Exception ex) {
                    HTMLPlugin.openAlertDialog(ex.toString());
                }
            }
        }
    }

    private class GenerateXSDAction
    extends Action {
        public GenerateXSDAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.GenerateXSD"));
        }

        public void run() {
            FileDialog dialog = new FileDialog(XMLEditor.this.getViewer().getTextWidget().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.xsd"});
            String file = dialog.open();
            if (file != null) {
                try {
                    SchemaGenerator.generateXSD(XMLEditor.this.getFile(), new File(file));
                }
                catch (Exception ex) {
                    HTMLPlugin.openAlertDialog(ex.toString());
                }
            }
        }
    }
}

