/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.DTDResolver;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

public class XMLOutlinePage
extends ContentOutlinePage
implements IHTMLOutlinePage {
    private XMLEditor editor;

    public XMLOutlinePage(XMLEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new XMLContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new XMLLabelProvider());
        try {
            if (viewer != null) {
                XMLRoot root = new XMLRoot(this.getDocument());
                viewer.setInput((Object)root);
                viewer.setExpandedState((Object)root.getChildren()[0], true);
            }
        }
        catch (SAXParseException root) {
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        viewer.addSelectionChangedListener((ISelectionChangedListener)new XMLSelectionChangedListener());
    }

    private Document getDocument() throws Exception {
        String xml = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new DTDResolver(this.editor.getDTDResolvers()));
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        return doc;
    }

    public void update() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            try {
                XMLRoot root = (XMLRoot)viewer.getInput();
                if (root == null) {
                    viewer.setInput((Object)new XMLRoot(this.getDocument()));
                } else {
                    root.setDocument(this.getDocument());
                }
                viewer.refresh();
            }
            catch (SAXParseException root) {
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
    }

    private SearchResult searchElement(int count, XMLElement element, XMLElement target) {
        SearchResult result = new SearchResult();
        if (element.equals(target)) {
            result.count = 1;
            result.find = true;
            return result;
        }
        IXMLTreeNode[] list = element.getChildren();
        int i = 0;
        while (i < list.length) {
            if (((XMLElement)list[i]).getName().equals(target.getName())) {
                ++count;
            }
            if (list[i] == target) {
                result.count = count;
                result.find = true;
                return result;
            }
            result = this.searchElement(count, (XMLElement)list[i], target);
            if (result.find) {
                return result;
            }
            count = result.count;
            ++i;
        }
        result.count = count;
        return result;
    }

    private interface IXMLTreeNode {
        public IXMLTreeNode[] getChildren();

        public IXMLTreeNode getParent();
    }

    private class XMLRoot
    implements IXMLTreeNode {
        private XMLElement[] children;

        public XMLRoot(Document doc) {
            this.children = new XMLElement[]{new XMLElement(this, doc.getDocumentElement(), 0)};
        }

        public void setDocument(Document doc) {
            this.children = new XMLElement[]{new XMLElement(this, doc.getDocumentElement(), 0)};
        }

        public IXMLTreeNode[] getChildren() {
            return this.children;
        }

        public IXMLTreeNode getParent() {
            return null;
        }

        public boolean equals(Object obj) {
            return obj instanceof XMLRoot;
        }

        public String toString() {
            return "root";
        }
    }

    private class XMLElement
    implements IXMLTreeNode {
        private IXMLTreeNode parent;
        private XMLElement[] children;
        private String name;
        private String attr;
        private String path;

        public XMLElement(IXMLTreeNode parent, Element element, int count) {
            this.parent = parent;
            this.name = element.getNodeName();
            this.path = String.valueOf(parent.toString()) + "/" + element.getNodeName() + "[" + count + "]";
            NamedNodeMap map = element.getAttributes();
            StringBuffer attrs = new StringBuffer();
            int i = 0;
            while (i < map.getLength()) {
                Attr attr = (Attr)map.item(i);
                if (attrs.length() != 0) {
                    attrs.append(", ");
                }
                attrs.append(String.valueOf(attr.getName()) + "=" + attr.getValue());
                ++i;
            }
            this.attr = attrs.length() != 0 ? "(" + attrs.toString() + ")" : "";
            NodeList list = element.getChildNodes();
            ArrayList<XMLElement> result = new ArrayList<XMLElement>();
            int i2 = 0;
            while (i2 < list.getLength()) {
                Node node = list.item(i2);
                if (node instanceof Element) {
                    result.add(new XMLElement(this, (Element)node, i2));
                }
                ++i2;
            }
            this.children = result.toArray(new XMLElement[result.size()]);
        }

        public IXMLTreeNode[] getChildren() {
            return this.children;
        }

        public IXMLTreeNode getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return String.valueOf(this.name) + this.attr;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object obj) {
            if (obj instanceof XMLElement) {
                return this.path.equals(((XMLElement)obj).getPath()) && this.parent.equals(((XMLElement)obj).getParent());
            }
            return false;
        }
    }

    private class XMLContentProvider
    implements ITreeContentProvider {
        XMLContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((IXMLTreeNode)parentElement).getChildren();
        }

        public Object getParent(Object element) {
            return ((IXMLTreeNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class XMLLabelProvider
    extends LabelProvider {
        XMLLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof XMLElement) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_tag");
            }
            return null;
        }
    }

    private class XMLSelectionChangedListener
    implements ISelectionChangedListener {
        private Object prev = null;

        XMLSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            XMLElement element = (XMLElement)sel.getFirstElement();
            if (element == null || element.equals(this.prev)) {
                return;
            }
            XMLRoot root = (XMLRoot)XMLOutlinePage.this.getTreeViewer().getInput();
            int count = ((XMLOutlinePage)XMLOutlinePage.this).searchElement((int)0, (XMLElement)((XMLElement)root.getChildren()[0]), (XMLElement)element).count;
            int offset = -1;
            String xml = XMLOutlinePage.this.editor.getDocumentProvider().getDocument((Object)XMLOutlinePage.this.editor.getEditorInput()).get();
            int i = 0;
            while (i < count) {
                offset = this.searchTag(xml, element.getName(), offset + 1);
                ++i;
            }
            if (offset != -1) {
                XMLOutlinePage.this.editor.selectAndReveal(offset, 0);
                XMLOutlinePage.this.editor.setFocus();
            }
            this.prev = element;
        }

        private int searchTag(String source, String tagName, int from) {
            source = HTMLUtil.comment2space(source, false);
            int index = -1;
            String[] suffix = new String[]{">", "/>", " ", "\t", "\r", "\n"};
            int i = 0;
            while (i < suffix.length) {
                index = source.indexOf("<" + tagName + suffix[i], from);
                if (index != -1) break;
                ++i;
            }
            return index;
        }
    }

    private class SearchResult {
        public int count = -1;
        public boolean find = false;

        SearchResult() {
        }
    }
}

