/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.Util;

public class ManagedBeanProperty {
    private ManagedBean parent;
    private String propertyName;
    private String propertyType;

    public ManagedBeanProperty(ManagedBean parent, String propertyName, String propertyType) {
        this.parent = parent;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public ManagedBean getParent() {
        return this.parent;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public ManagedBean toManagedBean() throws JavaModelException {
        IJavaProject project = this.parent.getProject();
        IType parentType = project.findType(this.parent.getClassName());
        String clazz = Util.getFullQName(parentType, this.propertyType);
        return new ManagedBean(parentType.getJavaProject(), clazz, this.propertyName, null);
    }

    public boolean equals(Object obj) {
        ManagedBeanProperty property;
        return obj instanceof ManagedBeanProperty && (property = (ManagedBeanProperty)obj).getParent().equals(this.parent) && property.getPropertyName().equals(this.propertyName) && property.getPropertyType().equals(this.propertyType);
    }
}

