/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;
import tk.eclipse.plugin.htmleditor.gefutils.LabelArrowConnection;
import tk.eclipse.plugin.jsf.editors.FacesConfigOperation;
import tk.eclipse.plugin.jsf.editors.editparts.AbstractNavigationConnectionEditPart;
import tk.eclipse.plugin.jsf.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.jsf.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.jsf.editors.models.ForwardModel;
import tk.eclipse.plugin.jsf.editors.models.PageModel;

public class ForwardEditPart
extends AbstractNavigationConnectionEditPart {
    private FacesConfigOperation operation;
    private ForwardDirectEditManager directManager;
    static /* synthetic */ Class class$0;

    public ForwardEditPart(FacesConfigOperation operation) {
        this.operation = operation;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ForwardDirectEditPolicy());
    }

    protected IFigure createFigure() {
        ForwardModel model = (ForwardModel)this.getModel();
        String name = "<navigation-case>";
        if (!model.getFromAction().equals("")) {
            name = model.getFromAction();
        } else if (!model.getFromOutcome().equals("")) {
            name = model.getFromOutcome();
        }
        LabelArrowConnection connection = new LabelArrowConnection();
        connection.setText(name);
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        if (model.getSource() == model.getTarget() && ((AbstractConnectionModel)this.getModel()).getBendpoints().size() == 0) {
            AbstractEntityModel source = model.getSource();
            Rectangle constraint = source.getConstraint();
            model.addBendpoint(0, new Point(constraint.x, constraint.y - 20));
            model.addBendpoint(1, new Point(constraint.x - 20, constraint.y - 20));
            model.addBendpoint(2, new Point(constraint.x - 20, constraint.y));
        }
        return connection;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        ForwardModel model = (ForwardModel)this.getModel();
        String name = (String)evt.getNewValue();
        String fromViewId = ((PageModel)model.getSource()).getPath();
        String toViewId = ((PageModel)model.getTarget()).getPath();
        String action = model.getFromAction();
        String outcome = model.getFromOutcome();
        this.operation.updateNavigation(fromViewId, toViewId, outcome, action);
        if (propName.equals("__bend_point")) {
            this.refreshBendpoints();
            return;
        }
        if (propName.equals("__from_action")) {
            if (name.equals("")) {
                name = model.getFromOutcome().equals("") ? "<navigation-case>" : model.getFromOutcome();
            }
        } else if (propName.equals("__from_outcome")) {
            if (name.equals("")) {
                name = model.getFromAction().equals("") ? "<navigation-case>" : model.getFromAction();
            }
        } else {
            return;
        }
        LabelArrowConnection connection = (LabelArrowConnection)this.getFigure();
        connection.setText(name);
        this.refreshVisuals();
    }

    protected void refreshBendpoints() {
        List bendpoints = ((AbstractConnectionModel)this.getModel()).getBendpoints();
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>();
        int i = 0;
        while (i < bendpoints.size()) {
            constraint.add(new AbsoluteBendpoint((Point)bendpoints.get(i)));
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }

    protected void refreshVisuals() {
        this.refreshBendpoints();
        super.refreshVisuals();
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.directManager = new ForwardDirectEditManager(clazz, new ForwardCellEditorLocator(this.getFigure()));
        }
        this.directManager.show();
    }

    private class ForwardDirectEditManager
    extends DirectEditManager {
        public ForwardDirectEditManager(Class editorType, CellEditorLocator locator) {
            super((GraphicalEditPart)ForwardEditPart.this, editorType, locator);
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((ForwardModel)ForwardEditPart.this.getModel()).getFromOutcome());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldFromOutcome;
        private String newFromOutcome;

        DirectEditCommand() {
        }

        public void execute() {
            ForwardModel model = (ForwardModel)ForwardEditPart.this.getModel();
            this.oldFromOutcome = model.getFromOutcome();
            model.setFromOutcome(this.newFromOutcome);
        }

        public void setFromOutcome(String fromOutcome) {
            this.newFromOutcome = fromOutcome;
        }

        public void undo() {
            ForwardModel model = (ForwardModel)ForwardEditPart.this.getModel();
            model.setFromOutcome(this.oldFromOutcome);
        }
    }

    private class ForwardDirectEditPolicy
    extends DirectEditPolicy {
        ForwardDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setFromOutcome((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }

    private class ForwardCellEditorLocator
    implements CellEditorLocator {
        private IFigure figure;

        public ForwardCellEditorLocator(IFigure f) {
            this.figure = f;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = ((LabelArrowConnection)this.figure).getLabel().getBounds().getCopy();
            this.figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }
}

