/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.template.TemplateFileCreator;
import tk.eclipse.plugin.jsf.wizards.JSPWizardPage;

public class JSPWizard
extends Wizard
implements INewWizard {
    private JSPWizardPage page;
    private ISelection selection;
    private String fileName = "newfile.jsp";
    private ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();

    public JSPWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.resource.getString("wizard.jsp.title"));
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void addPages() {
        this.page = new JSPWizardPage(this.selection, this.fileName);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final boolean useTomahawk = this.page.getUseMyFacesTomahawk();
        final Template template = this.page.getTemplate();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        JSPWizard.this.doFinish(containerName, fileName, useTomahawk, template, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            Util.openErrorDialog(realException);
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, boolean useTomahawk, Template template, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Util.createMessage(this.resource.getString("wizard.message.creation"), new String[]{fileName}), 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        String charset = HTMLUtil.getProjectCharset((IProject)file.getProject());
        String myfacesTaglib = "";
        if (useTomahawk) {
            myfacesTaglib = "<%@ taglib uri=\"http://myfaces.apache.org/tomahawk\" prefix=\"t\" %>\n";
        }
        try {
            TemplateFileCreator creator = new TemplateFileCreator();
            creator.create(file, template, charset, myfacesTaglib, monitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(this.resource.getString("wizard.message.openfile"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

