/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.JSFProject;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.wizards.ManagedBeanWizard;
import tk.eclipse.plugin.visualjsf.VisualJSFModelFactory;
import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;
import tk.eclipse.plugin.visualjsf.VisualJSFUtil;
import tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart;
import tk.eclipse.plugin.visualjsf.editparts.JSFEditPartFactory;
import tk.eclipse.plugin.visualjsf.loader.VisualJSFLoader;
import tk.eclipse.plugin.visualjsf.models.RootModel;

public class VisualJSFEditor
extends GraphicalEditorWithPalette {
    private RootModel root;
    private boolean savePreviouslyNeeded;
    private Set componentNames = new HashSet();
    public static final String MENU_GROUP_EDIT = "edit";
    public static final String MENU_GROUP_BEAN = "backingBean";
    public static final String MENU_GROUP_COMPONENT = "component";
    public static final String MENU_GROUP_ADDITIONS = "additions";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public VisualJSFEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getActionRegistry().registerAction((IAction)new UndoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new RedoRetargetAction());
    }

    protected PaletteRoot getPaletteRoot() {
        PaletteRoot root = new PaletteRoot();
        PaletteGroup tools = new PaletteGroup(VisualJSFPlugin.getResourceString("palette.tool"));
        SelectionToolEntry tool = new SelectionToolEntry();
        tools.add((PaletteEntry)tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tools.add((PaletteEntry)tool);
        PaletteDrawer html = new PaletteDrawer(VisualJSFPlugin.getResourceString("palette.component"));
        String string = VisualJSFPlugin.getResourceString("component.outputText");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("tk.eclipse.plugin.visualjsf.models.OutputTextModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CreationToolEntry labelEntry = new CreationToolEntry(string, "h:outputText", (CreationFactory)new VisualJSFModelFactory(clazz, this.componentNames), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_label"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_label"));
        html.add((PaletteEntry)labelEntry);
        String string2 = VisualJSFPlugin.getResourceString("component.inputText");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("tk.eclipse.plugin.visualjsf.models.InputTextModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CreationToolEntry textEntry = new CreationToolEntry(string2, "h:inputText", (CreationFactory)new VisualJSFModelFactory(clazz2, this.componentNames), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_text"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_text"));
        html.add((PaletteEntry)textEntry);
        String string3 = VisualJSFPlugin.getResourceString("component.commandButton");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("tk.eclipse.plugin.visualjsf.models.CommandButtonModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CreationToolEntry submitEntry = new CreationToolEntry(string3, "h:commandButton", (CreationFactory)new VisualJSFModelFactory(clazz3, this.componentNames), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_button"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_button"));
        html.add((PaletteEntry)submitEntry);
        root.add((PaletteEntry)tools);
        root.add((PaletteEntry)html);
        return root;
    }

    private String getBackingBeanName() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                HTMLProjectParams params = new HTMLProjectParams(file.getProject());
                String root = params.getRoot();
                if (root.startsWith("/")) {
                    root = root.substring(1);
                }
                String path = file.getProjectRelativePath().toString();
                path = path.substring(root.length());
                return VisualJSFUtil.getBackingBeanName(path);
            }
            catch (Exception ex) {
                VisualJSFPlugin.logException(ex);
            }
        }
        return null;
    }

    private void checkBackingBean() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
                JSFProject jsfProject = new JSFProject(javaProject);
                String beanName = this.getBackingBeanName();
                IType beanType = null;
                ManagedBean bean = jsfProject.getManagedBean(beanName);
                if (bean != null) {
                    beanType = javaProject.findType(bean.getClassName());
                }
                if (beanType == null || !beanType.exists()) {
                    beanType = null;
                    beanName = null;
                }
                this.root.setBackingBean(beanType, beanName);
            }
            catch (Exception ex) {
                VisualJSFPlugin.logException(ex);
            }
        }
    }

    public IAction getAction(Object key) {
        return this.getActionRegistry().getAction(key);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new JSFEditPartFactory());
    }

    protected void initializeGraphicalViewer() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                String source = new String(HTMLUtil.readStream((InputStream)file.getContents()), file.getCharset());
                this.root = VisualJSFLoader.loadJSP(source, this.componentNames);
                this.checkBackingBean();
            }
            catch (Exception ex) {
                VisualJSFPlugin.logException(ex);
            }
        }
        GraphicalViewer viewer = this.getGraphicalViewer();
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        viewer.setContents((Object)this.root);
        final DeleteAction deleteAction = new DeleteAction((IWorkbenchPart)this);
        deleteAction.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)deleteAction);
        this.getGraphicalViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteAction.update();
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new Separator(MENU_GROUP_EDIT));
        menuMgr.add(this.getAction(ActionFactory.UNDO.getId()));
        menuMgr.add(this.getAction(ActionFactory.REDO.getId()));
        menuMgr.add(this.getAction(ActionFactory.DELETE.getId()));
        menuMgr.add((IContributionItem)new Separator(MENU_GROUP_BEAN));
        menuMgr.add((IContributionItem)new Separator(MENU_GROUP_COMPONENT));
        menuMgr.add((IContributionItem)new Separator(MENU_GROUP_ADDITIONS));
        viewer.setContextMenu(menuMgr);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IAction[] actions;
                Object obj;
                manager.remove("registerBackingBean");
                manager.remove("openBackingBean");
                if (VisualJSFEditor.this.root.getBeanType() != null) {
                    manager.appendToGroup(VisualJSFEditor.MENU_GROUP_BEAN, (IAction)new OpenBackingBeanAction());
                } else {
                    manager.appendToGroup(VisualJSFEditor.MENU_GROUP_BEAN, (IAction)new CreateBackingBeanAction());
                }
                IContributionItem[] items = manager.getItems();
                boolean deleteFlag = true;
                int i = 0;
                while (i < items.length) {
                    if (items[i].isSeparator()) {
                        deleteFlag = items[i].getId().equals(VisualJSFEditor.MENU_GROUP_COMPONENT);
                    } else if (deleteFlag) {
                        manager.remove(items[i]);
                    }
                    ++i;
                }
                IStructuredSelection sel = (IStructuredSelection)VisualJSFEditor.this.getGraphicalViewer().getSelection();
                if (sel.getFirstElement() != null && (obj = sel.getFirstElement()) instanceof AbstractEditPart && (actions = ((AbstractEditPart)obj).getMenuActions()) != null) {
                    int i2 = 0;
                    while (i2 < actions.length) {
                        manager.appendToGroup(VisualJSFEditor.MENU_GROUP_COMPONENT, actions[i2]);
                        ++i2;
                    }
                }
            }
        });
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(this.getEditorInput().getName());
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.root != null) {
            this.checkBackingBean();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                file.setContents((InputStream)new ByteArrayInputStream(this.root.toHTML().getBytes()), false, true, monitor);
            }
            catch (Exception ex) {
                VisualJSFPlugin.logException(ex);
            }
        }
        this.setPartName(this.getEditorInput().getName());
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    private class CreateBackingBeanAction
    extends Action {
        public static final String ID = "registerBackingBean";

        public CreateBackingBeanAction() {
            super(VisualJSFPlugin.getResourceString("action.createBackingBean"), VisualJSFPlugin.getImageDescriptor("icons/bean.gif"));
            this.setId(ID);
        }

        public void run() {
            JSFProject project;
            IFile[] configFiles;
            IFileEditorInput input = (IFileEditorInput)VisualJSFEditor.this.getEditorInput();
            IFile file = input.getFile();
            ManagedBeanWizard wizard = new ManagedBeanWizard();
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)file.getProject()));
            wizard.setClassName("pages." + VisualJSFUtil.getBackingBeanClassName(file.getName()));
            WizardDialog dialog = new WizardDialog(VisualJSFEditor.this.getGraphicalViewer().getControl().getShell(), (IWizard)wizard);
            if (dialog.open() == 0 && (configFiles = (project = new JSFProject(JavaCore.create((IProject)file.getProject()))).getFacesConfigXML()).length > 0) {
                try {
                    IType type = (IType)wizard.getCreatedElement();
                    this.registerManagedBean(configFiles[0], type.getFullyQualifiedName(), VisualJSFEditor.this.getBackingBeanName());
                }
                catch (Exception ex) {
                    VisualJSFPlugin.logException(ex);
                }
                VisualJSFEditor.this.checkBackingBean();
            }
        }

        private void registerManagedBean(IFile config, String className, String beanName) throws Exception {
            FuzzyXMLDocument doc = new FuzzyXMLParser().parse(config.getContents());
            FuzzyXMLElement root = (FuzzyXMLElement)doc.getDocumentElement().getChildren()[0];
            FuzzyXMLNode[] children = root.getChildren();
            FuzzyXMLNode before = null;
            boolean flag = false;
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof FuzzyXMLElement) {
                    if (!flag && ((FuzzyXMLElement)children[i]).getName().equals("managed-bean")) {
                        flag = true;
                    }
                    if (flag && !((FuzzyXMLElement)children[i]).getName().equals("managed-bean")) {
                        before = children[i];
                        break;
                    }
                }
                ++i;
            }
            FuzzyXMLElement bean = doc.createElement("managed-bean");
            if (before == null) {
                root.appendChild((FuzzyXMLNode)doc.createText("\t"));
                root.appendChild((FuzzyXMLNode)bean);
            } else {
                FuzzyXMLText text = doc.createText("\t");
                root.insertBefore((FuzzyXMLNode)text, before);
                root.insertAfter((FuzzyXMLNode)bean, (FuzzyXMLNode)text);
            }
            bean.appendChild((FuzzyXMLNode)doc.createText("\n\t\t"));
            FuzzyXMLElement name = doc.createElement("managed-bean-name");
            bean.appendChild((FuzzyXMLNode)name);
            name.appendChild((FuzzyXMLNode)doc.createText(beanName));
            bean.appendChild((FuzzyXMLNode)doc.createText("\n\t\t"));
            FuzzyXMLElement clazz = doc.createElement("managed-bean-class");
            bean.appendChild((FuzzyXMLNode)clazz);
            clazz.appendChild((FuzzyXMLNode)doc.createText(className));
            bean.appendChild((FuzzyXMLNode)doc.createText("\n\t\t"));
            FuzzyXMLElement scope = doc.createElement("managed-bean-scope");
            bean.appendChild((FuzzyXMLNode)scope);
            scope.appendChild((FuzzyXMLNode)doc.createText("request"));
            bean.appendChild((FuzzyXMLNode)doc.createText("\n\t"));
            if (before == null) {
                root.appendChild((FuzzyXMLNode)doc.createText("\n"));
            } else {
                root.insertBefore((FuzzyXMLNode)doc.createText("\n"), before);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\"?>\n");
            sb.append("<!DOCTYPE faces-config PUBLIC ");
            sb.append("\"-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN\" ");
            sb.append("\"http://java.sun.com/dtd/web-facesconfig_1_1.dtd\">\n");
            sb.append(root.toXMLString());
            ByteArrayInputStream in = new ByteArrayInputStream(sb.toString().getBytes(config.getCharset()));
            config.setContents((InputStream)in, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private class OpenBackingBeanAction
    extends Action {
        public static final String ID = "openBackingBean";

        public OpenBackingBeanAction() {
            super(VisualJSFPlugin.getResourceString("action.openBackingBean"), VisualJSFPlugin.getImageDescriptor("icons/bean.gif"));
            this.setId(ID);
        }

        public void run() {
            IType type = VisualJSFEditor.this.root.getBeanType();
            VisualJSFUtil.openJavaElement((IJavaElement)type);
        }
    }
}

