/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.descriptors;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.gefutils.AbstractDialogPropertyDescriptor;
import tk.eclipse.plugin.jsf.JSFProject;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;
import tk.eclipse.plugin.visualjsf.descriptors.ActionSelectionDialog;
import tk.eclipse.plugin.visualjsf.descriptors.ManagedBeanMethod;

public class ActionPropertyDescriptor
extends AbstractDialogPropertyDescriptor {
    public ActionPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    protected Object openDialogBox(String value, Control cellEditorWindow) {
        try {
            Shell shell;
            ActionSelectionDialog dialog;
            IEditorPart editorPart = HTMLUtil.getActiveEditor();
            IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
            IJavaProject project = JavaCore.create((IProject)input.getFile().getProject());
            JSFProject jsfProject = new JSFProject(project);
            ManagedBean[] beans = jsfProject.getManagedBeans();
            ManagedBeanMethod initial = null;
            if (value.startsWith("#{") && value.endsWith("}")) {
                value = value.replaceAll("^#\\{", "");
                String[] dim = Util.splitManagedBean((String)(value = value.replaceAll("\\}$", "")));
                if (dim.length == 2) {
                    int i = 0;
                    while (i < beans.length) {
                        if (beans[i].getBeanName().equals(dim[0])) {
                            initial = new ManagedBeanMethod(beans[i], dim[1]);
                        }
                        ++i;
                    }
                }
            }
            if ((dialog = new ActionSelectionDialog(shell = cellEditorWindow.getShell(), beans, initial)).open() == 0) {
                Object[] result = dialog.getResult();
                if (result != null && result.length == 1 && result[0] instanceof ManagedBeanMethod) {
                    return this.convertToString((ManagedBeanMethod)result[0]);
                }
                return null;
            }
        }
        catch (Exception ex) {
            VisualJSFPlugin.logException(ex);
        }
        return null;
    }

    private String convertToString(ManagedBeanMethod method) {
        StringBuffer sb = new StringBuffer();
        sb.append("#{");
        sb.append(method.getParent().getBeanName());
        sb.append(".");
        sb.append(method.getMethodName());
        sb.append("}");
        return sb.toString();
    }
}

