/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;
import tk.eclipse.plugin.visualjsf.VisualJSFUtil;
import tk.eclipse.plugin.visualjsf.editparts.AbstractJSFEditPart;
import tk.eclipse.plugin.visualjsf.models.CommandButtonModel;

public class CommandButtonEditPart
extends AbstractJSFEditPart
implements ColorConstants {
    protected IFigure createFigure() {
        CommandButtonModel model = (CommandButtonModel)this.getModel();
        Label button = new Label(model.getValue());
        button.setBackgroundColor(Display.getDefault().getSystemColor(22));
        button.setOpaque(true);
        button.setBorder((Border)new SchemeBorder((SchemeBorder.Scheme)new ButtonBorder.ButtonScheme(new Color[]{buttonLightest}, new Color[]{buttonDarkest, buttonDarker})));
        return button;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        CommandButtonModel model = (CommandButtonModel)this.getModel();
        Label button = (Label)this.getFigure();
        button.setText(model.getValue());
    }

    public IAction[] getMenuActions() {
        CommandButtonModel model = (CommandButtonModel)this.getModel();
        String action = model.getAction();
        action = action.startsWith("#{") && action.endsWith("}") ? action.substring(action.lastIndexOf(46) + 1, action.length() - 1) : String.valueOf(model.getName()) + "Cliked";
        return new IAction[]{new CreateActionAction(action)};
    }

    private class CreateActionAction
    extends Action {
        public CreateActionAction(String text) {
            super(text, VisualJSFPlugin.getImageDescriptor("icons/event_1.gif"));
            this.setId("commandButton_action");
        }

        public void run() {
            IMethod method;
            final CommandButtonModel model = (CommandButtonModel)CommandButtonEditPart.this.getModel();
            IType beanType = model.getRoot().getBeanType();
            if (beanType == null) {
                return;
            }
            final String beanName = model.getRoot().getBeanName();
            final String methodName = this.getText();
            if (model.getAction() == null || model.getAction().length() == 0) {
                CommandStack stack = CommandButtonEditPart.this.getViewer().getEditDomain().getCommandStack();
                stack.execute(new Command(){

                    public void execute() {
                        model.setAction("#{" + beanName + "." + methodName + "}");
                    }

                    public void undo() {
                        model.setAction("");
                    }
                });
            }
            if ((method = beanType.getMethod(methodName, new String[0])) == null || !method.exists()) {
                VisualJSFUtil.createActionMethod(beanType, methodName, "success");
                method = beanType.getMethod(methodName, new String[0]);
            }
            VisualJSFUtil.openJavaElement((IJavaElement)method);
        }
    }
}

