/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import tk.eclipse.plugin.visualjsf.editparts.AbstractJSFEditPart;
import tk.eclipse.plugin.visualjsf.models.OutputTextModel;

public class OutputTextEditPart
extends AbstractJSFEditPart {
    protected IFigure createFigure() {
        OutputTextModel model = (OutputTextModel)this.getModel();
        Label label = new Label(model.getValue());
        label.setOpaque(true);
        label.setLabelAlignment(1);
        if (model.getColor() != null) {
            label.setForegroundColor(new Color((Device)Display.getDefault(), model.getColor()));
        }
        return label;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        OutputTextModel model = (OutputTextModel)this.getModel();
        Label label = (Label)this.getFigure();
        label.setText(model.getValue());
        if (model.getColor() != null) {
            label.setForegroundColor(new Color((Device)Display.getDefault(), model.getColor()));
        }
        if (model.getSize() != null) {
            FontData data = label.getFont().getFontData()[0];
            data.setHeight(this.getFontSize(model.getSize()));
            label.setFont(new Font((Device)Display.getDefault(), data));
        }
        label.repaint();
    }

    private int getFontSize(String size) {
        if (size.endsWith("px") || size.endsWith("pt")) {
            return Integer.parseInt(size.substring(0, size.length() - 2)) - 2;
        }
        if (size.endsWith("%")) {
            int value = Integer.parseInt(size.substring(0, size.length() - 1));
            return 10 * (value / 100);
        }
        return 10;
    }
}

