/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.AbstractModel;
import tk.eclipse.plugin.visualjsf.models.ModelProperty;

public class RootModel
extends AbstractModel {
    public static final String P_CHILDREN = "_children";
    public static final String P_TITLE = "_title";
    private String title = "";
    private ArrayList children = new ArrayList();
    private IType beanType;
    private String beanName;
    private Set componentNames;
    static /* synthetic */ Class class$0;

    public RootModel(Set componentNames) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addModelProperty(P_TITLE, new ModelProperty(this, "title", clazz, (IPropertyDescriptor)new TextPropertyDescriptor((Object)P_TITLE, "title")));
        this.componentNames = componentNames;
    }

    public void setBackingBean(IType type, String name) {
        this.beanType = type;
        this.beanName = name;
    }

    public IType getBeanType() {
        return this.beanType;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void addChild(AbstractJSFModel child) {
        this.children.add(child);
        child.added(this.beanType, this.beanName);
        this.componentNames.add(child.getName());
        child.setRoot(this);
        this.firePropertyChange(P_CHILDREN, null, null);
    }

    public List getChildren() {
        return this.children;
    }

    public void removeChild(AbstractJSFModel obj) {
        this.children.remove(obj);
        obj.removed(this.beanType, this.beanName);
        this.componentNames.remove(obj.getName());
        this.firePropertyChange(P_CHILDREN, null, null);
    }

    public void removeAll() {
        int i = 0;
        while (i < this.children.size()) {
            AbstractJSFModel child = (AbstractJSFModel)this.children.get(i);
            child.removed(this.beanType, this.beanName);
            this.componentNames.remove(child.getName());
            ++i;
        }
        this.children.clear();
        this.firePropertyChange(P_CHILDREN, null, null);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.firePropertyChange(P_TITLE, null, title);
    }

    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<%@ page contentType=\"text/html; charset=Windows-31J\" %>\n");
        sb.append("<%@ taglib uri=\"http://java.sun.com/jsf/html\" prefix=\"h\" %>\n");
        sb.append("<%@ taglib uri=\"http://java.sun.com/jsf/core\" prefix=\"f\" %>\n");
        sb.append("<html>\n");
        sb.append("\t<head>\n");
        sb.append("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=Windows-31J\"/>\n");
        sb.append("\t\t<title>").append(HTMLUtil.escapeHTML((String)this.getTitle())).append("</title>\n");
        sb.append("\t</head>\n");
        sb.append("\t<body>\n");
        sb.append("\t\t<f:view>\n");
        sb.append("\t\t\t<h:form>\n");
        int i = 0;
        while (i < this.children.size()) {
            AbstractJSFModel model = (AbstractJSFModel)this.children.get(i);
            sb.append("\t\t\t\t");
            sb.append(model.toHTML());
            sb.append("\n");
            ++i;
        }
        sb.append("\t\t\t</h:form>\n");
        sb.append("\t\t</f:view>\n");
        sb.append("\t</body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }
}

