package net.java.amateras.xlsbeans.example;

import java.util.List;

import net.java.amateras.xlsbeans.annotation.HorizontalRecords;
import net.java.amateras.xlsbeans.annotation.LabelledCell;
import net.java.amateras.xlsbeans.annotation.LabelledCellType;
import net.java.amateras.xlsbeans.annotation.Sheet;

@Sheet(name="IDE")
public class IDEList {
	
	private String title = null;
	private List<IDE> ides;

	public String getTitle() {
		return title;
	}

	@LabelledCell(label="Title", optional=true, type=LabelledCellType.Right)
	public void setTitle(String title) {
		this.title = title;
	}
	
	public List<IDE> getIDEs() {
		return ides;
	}

	@HorizontalRecords(tableLabel="Java IDEs", recordClass=IDE.class)
	public void setIDEs(List<IDE> ides) {
		this.ides = ides;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer("- Java IDEs");
		sb.append(System.getProperty("line.separator"));
		sb.append("Title=");
		sb.append(getTitle());
		sb.append(System.getProperty("line.separator"));
		for(IDE ide : ides){
			sb.append(ide.toString());
			sb.append(System.getProperty("line.separator"));
		}
		return sb.toString();
	}
	
}
