package net.java.amateras.xlsbeans.example;

import java.util.Iterator;
import java.util.Map;

import net.java.amateras.xlsbeans.annotation.Column;
import net.java.amateras.xlsbeans.annotation.MapColumns;

public class LanguageIDE {
	
	private String name;
	private Map attributes;
	
	public Map getAttributes() {
		return attributes;
	}
	
	@MapColumns(previousColumnName="Name")
	public void setAttributes(Map attributes) {
		this.attributes = attributes;
	}
	
	public String getName() {
		return name;
	}
	
	@Column(columnName="Name")
	public void setName(String name) {
		this.name = name;
	}
	
	public String toString(){
		StringBuilder sb = new StringBuilder(name);
		sb.append("(");
		for(Iterator ite = attributes.entrySet().iterator();ite.hasNext();){
			Map.Entry entry = (Map.Entry)ite.next();
			sb.append(entry.getKey() + "=" + entry.getValue() + ", ");
		}
		sb.append(")");
		return sb.toString();
	}
	
}
