package net.java.amateras.xlsbeans.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * An annotation for the property which is mapped to the horizontal table records.
 * 
 * @author Naoki Takezoe
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface HorizontalRecords {
	
	boolean optional() default false;
	String tableLabel() default "";
	int headerRow() default -1;
	int headerColumn() default -1;
	Class recordClass();
	RecordTerminal terminal() default RecordTerminal.Empty;
	int range() default 1;
	
}
