package net.java.amateras.xlsbeans.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 
 * @author Naoki Takezoe
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface Sheet {
	
	/**
	 * Returns the mapped sheet name.
	 * 
	 * @return the sheet name
	 */
	String name() default "";
	
	/**
	 * Returns the mapped sheet number.
	 * 
	 * @return the sheet number
	 */
	int number() default -1;
}
