package net.java.amateras.xlsbeans.processor;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;

import net.java.amateras.xlsbeans.annotation.Cell;
import net.java.amateras.xlsbeans.annotation.HorizontalRecords;
import net.java.amateras.xlsbeans.annotation.LabelledCell;
import net.java.amateras.xlsbeans.annotation.SheetName;
import net.java.amateras.xlsbeans.annotation.VerticalRecords;

/**
 * 
 * @author Naoki Takezoe
 */
public class FieldProcessorFactory {
	
	private static ConcurrentHashMap<Class<? extends Annotation>, FieldProcessor>
		map = new ConcurrentHashMap<Class<? extends Annotation>, FieldProcessor>();
	
	static {
		map.put(Cell.class, new CellProcessor());
		map.put(LabelledCell.class, new LabelledCellProcessor());
		map.put(HorizontalRecords.class, new HorizontalRecordsProcessor());
		map.put(VerticalRecords.class, new VerticalRecordsProcessor());
		map.put(SheetName.class, new SheetNameProcessor());
	}
	
	public static FieldProcessor getProcessor(Annotation ann){
		return map.get(ann.annotationType());
	}
	
}
