package net.java.amateras.xlsbeans.example;

import java.util.List;

import net.java.amateras.xlsbeans.annotation.HorizontalRecords;
import net.java.amateras.xlsbeans.annotation.IterateTables;
import net.java.amateras.xlsbeans.annotation.LabelledCell;
import net.java.amateras.xlsbeans.annotation.LabelledCellType;
import net.java.amateras.xlsbeans.annotation.Sheet;
import net.java.amateras.xlsbeans.annotation.VerticalRecords;

/**
 * 
 * @author Naoki Takezoe
 */
@Sheet(name="Users2")
public class UserList {
	
	private List<User> horizontalUsers;
	private List<User> verticalUsers;
	private String title;
	private String lastUpdate;
	private List<UnitUser> unitUsers;
	private String actionClassName;
	private String formClassName;
	
	public List<UnitUser> getUnitUsers() {
		return unitUsers;
	}

	@IterateTables(tableLabel="", tableClass=Unit.class, bottom=2)
	public void setUnitUsers(List<UnitUser> unitUsers) {
		this.unitUsers = unitUsers;
	}

	public List<User> getVerticalUsers() {
		return verticalUsers;
	}
	
	@VerticalRecords(tableLabel="Vertical Table", recordClass=User.class)
	public void setVerticalUsers(List<User> verticalUsers) {
		this.verticalUsers = verticalUsers;
	}

	@HorizontalRecords(tableLabel="User Informations", recordClass=User.class, terminateLabel="Terminate")
	public void setHorizontalUsers(List<User> users){
		this.horizontalUsers = users;
	}
	
	public List<User> getHorizontalUsers(){
		return this.horizontalUsers;
	}
	
	@LabelledCell(label="Title", type=LabelledCellType.Right)
	public void setTitle(String title){
		this.title = title;
	}
	
	public String getTitle(){
		return this.title;
	}
	
	@LabelledCell(label="LastUpdated", type=LabelledCellType.Right)
	public void setLastUpdate(String lastUpdate){
		this.lastUpdate = lastUpdate;
	}
	
	public String getLastUpdate(){
		return this.lastUpdate;
	}

	public String getActionClassName() {
		return actionClassName;
	}
	
	@LabelledCell(label="NX", headerLabel="ANV", type=LabelledCellType.Right)
	public void setActionClassName(String actionClassName) {
		this.actionClassName = actionClassName;
	}

	public String getFormClassName() {
		return formClassName;
	}

	@LabelledCell(label="NX", headerLabel="ANVtH[", type=LabelledCellType.Right)
	public void setFormClassName(String formClassName) {
		this.formClassName = formClassName;
	}
	
	
	
}
