package net.java.amateras.xlsbeans.example;

import net.java.amateras.xlsbeans.XLSBeans;
import net.java.amateras.xlsbeans.sandbox.DumpXLSBeans;

/**
 * 
 * @author Naoki Takezoe
 */
public class XLSBeansExample {
	
	private static void test1() throws Exception {
		
		System.out.println("*************************************");
		System.out.println("test1");
		System.out.println("*************************************");
		
		UserList userList = new XLSBeans().load(
				XLSBeansExample.class.getResourceAsStream("example_1.xls"),
				XLSBeansExample.class.getResourceAsStream("example_1.xml"),
				UserList.class);
		
		DumpXLSBeans.showDump(userList);
		
//		System.out.println("Title="+userList.getTitle());
//		System.out.println("LastUpdated="+userList.getLastUpdate());
//		
//		System.out.println("- Horizontal Table");
//		
//		for(User user : userList.getHorizontalUsers()){
//			//System.out.println(user.toString());
//			DumpXLSBeans.showDump(user);
//		}
//		
//		System.out.println("- Vertical Table");
//		
//		for(User user : userList.getVerticalUsers()){
//			//System.out.println(user.toString());
//			DumpXLSBeans.showDump(user);
//		}
	}
	
	private static void test2() throws Exception {
		UserList[] userLists = new XLSBeans().loadMultiple(
				XLSBeansExample.class.getResourceAsStream("example_1.xls"),
				XLSBeansExample.class.getResourceAsStream("example_1.xml"),
				UserList.class);
		
		System.out.println("*************************************");
		System.out.println("test2");
		System.out.println("*************************************");
		
		for(UserList userList : userLists){
			DumpXLSBeans.showDump(userList);
//			System.out.println("--");
//			System.out.println("Title="+userList.getTitle());
//			System.out.println("LastUpdated="+userList.getLastUpdate());
//			
//			System.out.println("- Horizontal Table");
//			
//			for(User user : userList.getHorizontalUsers()){
//				System.out.println(user.toString());
//			}
//			
//			System.out.println("- Vertical Table");
//			
//			for(User user : userList.getVerticalUsers()){
//				System.out.println(user.toString());
//			}
		}
	}
	
	private static void test3() throws Exception {
		Object[] objList = new XLSBeans().loadMultiple(
				XLSBeansExample.class.getResourceAsStream("example_2.xls"),
				null,
				new Class<?>[]{ LanguageList.class, IDEList.class});
		
		System.out.println("*************************************");
		System.out.println("test3");
		System.out.println("*************************************");
		
		for(Object obj : objList){
			DumpXLSBeans.showDump(obj);
		}
	}
	
	public static void main(String[] args) throws Exception {
		test1();
		test2();
		test3();
	}
	
}
