package net.java.amateras.xlsbeans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import jxl.Cell;
import jxl.Sheet;
import net.java.amateras.xlsbeans.annotation.Column;
import net.java.amateras.xlsbeans.annotation.MapColumns;
import net.java.amateras.xlsbeans.xml.AnnotationReader;

/**
 * 
 * @author Naoki Takezoe
 * @author Mitsuyoshi Hasegawa
 */
public class Utils {
	
	public static Method[] getMapColumnMethod(Object obj, 
			AnnotationReader reader) throws Exception {
		
		List<Method> result = new ArrayList<Method>();
		Method[] methods = obj.getClass().getMethods();
		for(int i=0;i<methods.length;i++){
			if(methods[i].getName().startsWith("set") &&
					methods[i].getParameterTypes().length==1){
				Annotation[] anns = reader.getAnnotations(obj.getClass(), methods[i]);
				
				for(int j=0;j<anns.length;j++){
					if(anns[j] instanceof MapColumns){
						result.add(methods[i]);
					}
				}
			}
		}
		return result.toArray(new Method[result.size()]);
	}
	
	public static Method[] getColumnMethod(
			Object obj, String name, AnnotationReader reader) throws Exception {
		
		List<Method> result = new ArrayList<Method>();
		Method[] methods = obj.getClass().getMethods();
		for(int i=0;i<methods.length;i++){
			if(methods[i].getName().startsWith("set") &&
					methods[i].getParameterTypes().length==1){
				Annotation[] anns = reader.getAnnotations(obj.getClass(), methods[i]);
				for(int j=0;j<anns.length;j++){
					if(anns[j] instanceof Column){
						Column column = (Column)anns[j];
						String columnName = column.columnName();
						if(name==null){
							result.add(methods[i]);
						} else if(columnName.equals(name)){
							result.add(methods[i]);
						}
					}
				}
			}
		}
		return result.toArray(new Method[result.size()]);
	}
	
	public static Cell getCell(Sheet sheet, String label, int from) throws XLSBeansException {
		int rows = sheet.getColumns();
		for(int i=0;i<rows;i++){
			Cell[] columns = sheet.getColumn(i);
			for(int j=from;j<columns.length;j++){
				if(columns[j].getContents().equals(label)){
					return columns[j];
				}
			}
		}
		throw new XLSBeansException("Cell '" + label + "' doesn't exist.");
	}
	
	/**
	 * Invokes the setter method using reflection.
	 * 
	 * @param setter the setter method
	 * @param obj the target object
	 * @param value the value which is String, primitive types or wrapper types
	 * @throws Exception
	 */
	public static void invokeSetter(Method setter,Object obj,String value) throws Exception {
		Class<?>[] types = setter.getParameterTypes();
		if(types.length!=1){
			return;
		}
		if(types[0].equals(String.class)){
			setter.invoke(obj, new Object[]{value});
		} else if(types[0].equals(Integer.TYPE) || types[0].equals(Integer.class)){
			if(value.length()==0){
				value = "0";
			}
			setter.invoke(obj, new Object[]{new Integer(value)});
		} else if(types[0].equals(Double.TYPE) || types[0].equals(Double.class)){
			if(value.length()==0){
				value = "0";
			}
			setter.invoke(obj, new Object[]{new Double(value)});
		} else if(types[0].equals(Short.TYPE) || types[0].equals(Short.class)){
			if(value.length()==0){
				value = "0";
			}
			setter.invoke(obj, new Object[]{new Short(value)});
		} else if(types[0].equals(Long.TYPE) || types[0].equals(Long.class)){
			if(value.length()==0){
				value = "0";
			}
			setter.invoke(obj, new Object[]{new Short(value)});
		} else if(types[0].equals(Float.TYPE) || types[0].equals(Float.class)){
			if(value.length()==0){
				value = "0";
			}
			setter.invoke(obj, new Object[]{new Float(value)});
		} else if(types[0].equals(Boolean.TYPE) || types[0].equals(Boolean.class)){
			if(value.length()==0){
				value = "false";
			}
			setter.invoke(obj, new Object[]{new Boolean(value)});
		} else if(types[0].equals(Character.TYPE) || types[0].equals(Character.class)){
			if(value.length()!=0){
				setter.invoke(obj, new Object[]{new Character(value.charAt(0))});
			}
		}
	}
	
	/**
	 * ZɊYZAԋpB OɃZIuWFNgw肷ƁÃZẼZ B
	 * 
	 * @param sheet
	 *            JExcel Api V[gIuWFNg
	 * @param label
	 *            Ώۂ̕
	 * @param after
	 *            ̃IuWFNǧÊ݌B
	 * @return ʂƂȂZIuWFNg
	 * @throws XLSBeansException
	 *             炩̗O
	 */
	public static Cell getCell(Sheet sheet, String label, Cell after)
			throws XLSBeansException {
		return getCell(sheet, label, after, false);
	}

	/**
	 * ZɊYZAԋpB OɃZIuWFNgw肷ƁÃZẼZ B
	 * 
	 * @param sheet
	 *            JExcel Api V[gIuWFNg
	 * @param label
	 *            Ώۂ̕
	 * @param after
	 *            ̃IuWFNǧÊ݌B
	 * @param includeingAfter
	 *            after ̃ZgΏۂƂ݂Ȃۂ
	 * @return ʂƂȂZIuWFNg
	 * @throws XLSBeansException
	 *             炩̗O
	 */
	public static Cell getCell(Sheet sheet, String label, Cell after,
			boolean includeAfter) throws XLSBeansException {

		if (after == null) {
			// Call XLSBeans#getCell() - method if third argument is null.
			return Utils.getCell(sheet, label, 0);
		}

		int columnStart = after.getColumn();
		int rowStart = after.getRow();

		for (int col = columnStart; col < sheet.getColumns(); col++) {
			// getting cells each columns
			Cell[] columns = sheet.getColumn(col);
			for (int row = rowStart; row < columns.length; row++) {
				// except first cell if "includeAfter" is false.
				if (col == columnStart && row == rowStart && !includeAfter) {
					continue;
				}
				if (columns[row].getContents().equals(label)) {
					return columns[row];
				}
			}
		}
		// can't find cell
		return null;
	}
	
	/**
	 * JavaBean Aw肵Ame[V\bh擾B
	 * 
	 * @param tableObj
	 *            e[u JavaBeans
	 * @param reader
	 *            AnnotationReader IuWFNg
	 * @param clazz
	 *            oΏۂ̃Ame[VNX
	 * @return setter \bhz
	 * @throws Exception
	 *             炩̗O
	 */
	public static Method[] getMethodWithAnnotation(Object tableObj,
			AnnotationReader reader, Class<?> clazz) throws Exception {
		List<Method> result = new ArrayList<Method>();
		Method[] methods = tableObj.getClass().getMethods();

		for (Method method : methods) {
			// setter
			if (method.getName().startsWith("set")
					&& method.getParameterTypes().length == 1) {
				// find annotation
				Annotation[] ans = reader.getAnnotations(tableObj.getClass(),
						method);
				for (Annotation an : ans) {
					if (an.annotationType().isAssignableFrom(clazz)) {
						result.add(method);
						break;
					}
				}
			}
		}
		return result.toArray(new Method[result.size()]);
	}
}
