package net.sf.amateras.air;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

import net.sf.amateras.air.as.EditorColorProvider;
import net.sf.amateras.air.builder.AirBuilderManager;
import net.sf.amateras.air.debug.debugger.FdbRunner;
import net.sf.amateras.air.util.AIRResources;
import net.sf.amateras.air.util.ColorManager;
import net.sf.amateras.air.util.FontManager;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class AIRPlugin extends AbstractUIPlugin {

	/** Preference Key: AIR SDK Path */
	public static final String PREF_AIR_SDK_PATH = "airSdkPath";

	/** Preference Key: Flex SDK Path */
	public static final String PREF_FLEX_SDK_PATH = "flexSdkPath";

	/** Preference Key: Flex Libraries */
	public static final String PREF_FLEX_LIBRARIES = "flexLibraries";

	/** Preference Key: Compile Infomation */
	public static final String PREF_FLEX_COMPILES = "flexCompiles";

	/** Preference Key: Application Descriptor Namespace */
	public static final String PREF_DESCRIPTOR_NAMESPACE = "flexDescriptorNamespace";

	/** Preference Key: fcsh shell command */
	public static final String PREF_FCSH_SHELL_COMMAND = "fcshShellCommand";

	/** Preference Key: adl shell command */
	public static final String PREF_ADL_COMMAND = "adlCommand";

	/** Preference Key: adt shell command */
	public static final String PREF_ADT_COMMAND = "adtCommand";

	/** Preference Key: fdb shell command */
	public static final String PREF_FDB_COMMAND = "fdbCommand";

	/** Preference Key: asdoc shell command */
	public static final String PREF_ASDOC_COMMAND = "asDocCommand";

	/** Preference Key: Air CompileCommand */
	public static final String PREF_AIR_COMPILE_COMMAND = "flexCompileCommand";

	/** Preference Key: Air CompileOption */
	public static final String PREF_AIR_COMPILE_OPTION = "flexCompileCommandOption";

	/** Preference Key: AS3 CompileCommand */
	public static final String PREF_AS3_COMPILE_COMMAND = "as3CompileCommand";

	/** Preferencd Key: AS3 CompileOption */
	public static final String PREF_AS3_COMPILE_OPTION = "as3CompileCommandOption";

	/** Preferencd Key: FLEX CompileOption */
	public static final String PREF_FLEX3_COMPILE_COMMAND = "flex3CompileCommand";

	/** Preferencd Key: FLEX CompileOption */
	public static final String PREF_FLEX3_COMPILE_OPTION = "flex3CompileCommandOption";

	/** Prefernce Key: Compile FilPattern */
	public static final String PREF_COMPILE_MESSAGE_PATTERN = "compileMessagePattern";

	public static final String PREF_COMPILE_FAIL_PATTERN = "compileFailPattern";

	public static final String PREF_COMPILE_ERROR_PATTERN = "compileErrorPattern";

	public static final String PREF_COMPILE_WARNING_PATTERN = "compileWarningPattern";

	public static final String PREF_COMPILE_FAIL_PATTERN_2 = "compileFailPattern2";

	public static final String PREF_COMPILE_ERROR_PATTERN_2 = "compileErrorPattern2";

	public static final String PREF_COMPILE_WARNING_PATTERN_2 = "compileWarningPattern2";

	public static final String PREF_COMPILE_TARGET_NOT_FOUND_PATTERN = "compileTargetNotFoundPattern";

	public static final String PREF_IS_ADD_MARKER_COMPILE_INFO = "isAddMarkerCompileInfo";

	/** Preference Key:Export */
	public static final String PREF_EXPORT_STORE_TYPE = "exportStoreType";

	public static final String PREF_EXPORT_KEY_STORE = "exportKeyStore";

	public static final String PREF_EXPORT_STORE_PASS = "exportStorePass";

	public static final String PREF_EXPORT_PACKAGE_NAME = "exportPackageName";

	public static final String PREF_EXPORT_PACK_LIST = "exportPackList";

	/** Preference Key: Application Descriptor */
	public static final String PREF_DESCRIPTOR = "decriptor";

	public static final String PREF_COLOR_DEFAULT = "colorDefault";

	public static final String PREF_COLOR_COMMENT = "colorComment";

	public static final String PREF_COLOR_STRING = "colorString";

	public static final String PREF_COLOR_KEYWORD = "colorKeyword";

	public static final String PREF_FONT_MATTING_SIZE = "fontMattingSize";

	public static final String CONTEXT_AS3_TYPE_ID = "net.sf.amateras.air.templates.as3";

	public static final String CONTEXT_MXML_TYPE_ID = "net.sf.amateras.air.templates.mxml";

	public static final String CONTEXT_DESCRIPTOR_TYPE_ID = "net.sf.amateras.air.templates.descriptor";

	public static final String TEMPLATE_STORE_ID = "net.sf.amateras.air.templates.store";

	/** Preference Key : Formatter */
	public static final String PREF_FORMATTER_TAB_POLICY = "formatterTabPolicy";

	public static final String PREF_FORMATTER_SPACE_INDENT_SIZE = "formatterSpaceIndentSize";

	public static final String PREF_FORMATTER_BRACE = "formatterBrace";

	/** Preference Key : ActionScript3 */
	public static final String PREF_SDK_SOURCES = "sdkSources";

	public static final String PREF_AS3_IS_PARSE_ENABLED = "as3IsParseEnabled";

	public static final String PREF_AS3_IS_SHOW_OUTLINE_ENABLED = "as3IsShowOutline";

	public static final String PREF_AS3_IS_CONTENT_ASSIST_MXML_ENABLED = "as3IsContentAssistMXML";

	public static final String PREF_AS3_IS_CONTENT_ASSIST_AS3_ENABLED = "as3IsContentAssistAS3";

	public static final String PREF_AS3_IS_CONTENT_ASSIST_FLEX_ENABLED = "as3IsContentAssistFLEX";

	// debug
	public static final String ATTR_AIR_PROGRAM = "net.sf.amateras.air.attriubute.program";

	public static final String ID_AIR_DEBUG_MODEL = "net.sf.amateras.air.debug.model";

	// The plug-in ID
	public static final String PLUGIN_ID = "net.sf.amateras.air";

	// The shared instance
	private static AIRPlugin plugin;

	private EditorColorProvider editorColorProvider;

	private ColorManager colorManager;

	private FontManager fontManager;

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("airplugin");

	private String nameSpacePrefix = "mx:";

	//Template
	private ContributionTemplateStore as3TemplateStore = null;

	private ContributionTemplateStore mxmlTemplateStore = null;

	private ContributionTemplateStore descriptorTemplateStore = null;

	private ContributionContextTypeRegistry as3ContextRegistry = null;

	private ContributionContextTypeRegistry mxmlContextRegistry = null;

	private ContributionContextTypeRegistry descriptorContextRegistry = null;

	/**
	 * The constructor
	 */
	public AIRPlugin() {
	}

	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
		editorColorProvider = new EditorColorProvider(getPreferenceStore());
		colorManager = new ColorManager();
		fontManager = new FontManager();
		plugin = this;

	}

	@Override
	protected void initializeImageRegistry(ImageRegistry reg) {
		super.initializeImageRegistry(reg);
		ComponentImageRegistry.init();
		//image
		reg.put(AIRResources.SET_PROPERTY_IMAGE, getImageDescriptor("icons/set_property.gif"));
		reg.put(AIRResources.CONTENTS_ASSIST_RESERVED_WORD, getImageDescriptor("icons/reservedword.gif"));
		reg.put(AIRResources.CONTENTS_ASSIST_TEMPLATE, getImageDescriptor("icons/text.gif"));

		reg.put(AIRResources.SOURCE_FOLDER, getImageDescriptor("icons/sourcefolder.gif"));
		reg.put(AIRResources.SOURCE_FOLDER_AIR, getImageDescriptor("icons/sourcefolder_air.gif"));
		reg.put(AIRResources.SOURCE_FOLDER_AS, getImageDescriptor("icons/sourcefolder_as.gif"));
		reg.put(AIRResources.SOURCE_FOLDER_FLEX, getImageDescriptor("icons/sourcefolder_flex.gif"));
		reg.put(AIRResources.SWC_JAR, getImageDescriptor("icons/swc.gif"));

		reg.put(AIRResources.PROPERTY_PUBLIC, getImageDescriptor("icons/classobj/field_public_obj.png"));
		reg.put(AIRResources.PROPERTY_PROTECTED, getImageDescriptor("icons/classobj/field_protected_obj.png"));
		reg.put(AIRResources.PROPERTY_PRIVATE, getImageDescriptor("icons/classobj/field_private_obj.png"));
		reg.put(AIRResources.PROPERTY_DEFAULT, getImageDescriptor("icons/classobj/field_default_obj.png"));
		reg.put(AIRResources.METHOD_PUBLIC, getImageDescriptor("icons/classobj/methpub_obj.png"));
		reg.put(AIRResources.METHOD_PROTECTED, getImageDescriptor("icons/classobj/methpro_obj.png"));
		reg.put(AIRResources.METHOD_PRIVATE, getImageDescriptor("icons/classobj/methpri_obj.png"));
		reg.put(AIRResources.METHOD_DEFAULT, getImageDescriptor("icons/classobj/methdef_obj.png"));
		reg.put(AIRResources.IMPORTS, getImageDescriptor("icons/classobj/impc_obj.png"));
		reg.put(AIRResources.IMPORT, getImageDescriptor("icons/classobj/imp_obj.png"));
		reg.put(AIRResources.CLASS_PUBLIC, getImageDescriptor("icons/classobj/innerclass_public_obj.png"));
		reg.put(AIRResources.CLASS_PRIVATE, getImageDescriptor("icons/classobj/innerclass_private_obj.png"));
		reg.put(AIRResources.CLASS_PROTECTED, getImageDescriptor("icons/classobj/innerclass_protected_obj.png"));
		reg.put(AIRResources.CLASS_DEFALUT, getImageDescriptor("icons/classobj/innerclass_default_obj.png"));
		reg.put(AIRResources.INTERFACE_PUBLIC, getImageDescriptor("icons/classobj/innerinterface_public_obj.png"));
		reg.put(AIRResources.INTERFACE_PRIVATE, getImageDescriptor("icons/classobj/innerinterface_private_obj.png"));
		reg
				.put(AIRResources.INTERFACE_PROTECTED,
						getImageDescriptor("icons/classobj/innerinterface_protected_obj.png"));
		reg.put(AIRResources.INTERFACE_DEFALUT, getImageDescriptor("icons/classobj/innerclass_default_obj.png"));
		reg.put(AIRResources.PACKAGE, getImageDescriptor("icons/classobj/package_obj.png"));
		reg.put(AIRResources.CONST, getImageDescriptor("icons/classobj/const.gif"));
	}

	public ColorManager getColorManager() {
		return this.colorManager;
	}

	public FontManager getFontManager() {
		return this.fontManager;
	}

	public EditorColorProvider getEditorColorProvider() {
		return this.editorColorProvider;
	}

	@Override
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		editorColorProvider.dispose();
		colorManager.dispose();
		fontManager.dispose();
		AirBuilderManager.shutdownCompilers();
		if (FdbRunner.getInstance() != null) {
			FdbRunner.getInstance().dispose();
		}
		ComponentImageRegistry.dispose();
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static AIRPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	public String getNameSpacePrefix() {
		return nameSpacePrefix;
	}

	public static void logException(Throwable ex) {
		ILog log = getDefault().getLog();
		IStatus status = null;
		if (ex instanceof CoreException) {
			status = ((CoreException) ex).getStatus();
		} else {
			status = new Status(IStatus.ERROR, PLUGIN_ID, 0, ex.toString(), ex);
		}
		log.log(status);

		// TODO Debug
		ex.printStackTrace();
	}

	public static void addNature(IProject project, String natureId) {
		try {
			IProjectDescription description = project.getDescription();
			String[] natures = description.getNatureIds();
			for (int i = 0; i < natures.length; i++) {
				if (natures[i].equals(natureId)) {
					return;
				}
			}
			String[] newNatures = new String[natures.length + 1];
			System.arraycopy(natures, 0, newNatures, 0, natures.length);
			newNatures[natures.length] = natureId;
			description.setNatureIds(newNatures);
			project.setDescription(description, null);

		} catch (Exception ex) {
			logException(ex);
		}
	}

	public static void removeNature(IProject project, String natureId) {
		try {
			IProjectDescription description = project.getDescription();
			String[] natures = description.getNatureIds();
			for (int i = 0; i < natures.length; ++i) {
				if (natureId.equals(natures[i])) {
					String[] newNatures = new String[natures.length - 1];
					System.arraycopy(natures, 0, newNatures, 0, i);
					System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
					description.setNatureIds(newNatures);
					project.setDescription(description, null);
					return;
				}
			}
		} catch (Exception ex) {
			logException(ex);
		}

	}

	// **************************************
	// ResourceBundle
	// **************************************
	public static String getResourceString(String key) {
		return RESOURCE_BUNDLE.getString(key);
	}

	public static String getResourceString(String key, Object... args) {
		String value = RESOURCE_BUNDLE.getString(key);
		return MessageFormat.format(value, args);
	}

	public static ResourceBundle getResourceBundle() {
		return RESOURCE_BUNDLE;
	}

	// **************************************
	// Template
	// **************************************
	public TemplateStore getTemplateAS3Store() {
		if (as3TemplateStore == null) {
			as3TemplateStore = new ContributionTemplateStore(getCotextAS3TypeRegistry(), getPreferenceStore(),
					TEMPLATE_STORE_ID);
			try {
				as3TemplateStore.load();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return as3TemplateStore;
	}

	public TemplateStore getTemplateMXMLStore() {
		if (mxmlTemplateStore == null) {
			mxmlTemplateStore = new ContributionTemplateStore(getCotextMXMLTypeRegistry(), getPreferenceStore(),
					TEMPLATE_STORE_ID);
			try {
				mxmlTemplateStore.load();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return mxmlTemplateStore;
	}

	public TemplateStore getTemplateDescriptorStore() {
		if (descriptorTemplateStore == null) {
			descriptorTemplateStore = new ContributionTemplateStore(getCotextDescriptorTypeRegistry(),
					getPreferenceStore(), TEMPLATE_STORE_ID);
			try {
				descriptorTemplateStore.load();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return descriptorTemplateStore;
	}

	public ContextTypeRegistry getCotextAS3TypeRegistry() {
		if (as3ContextRegistry == null) {
			as3ContextRegistry = new ContributionContextTypeRegistry();
			as3ContextRegistry.addContextType(CONTEXT_AS3_TYPE_ID);
		}
		return as3ContextRegistry;
	}

	public ContextTypeRegistry getCotextMXMLTypeRegistry() {
		if (mxmlContextRegistry == null) {
			mxmlContextRegistry = new ContributionContextTypeRegistry();
			mxmlContextRegistry.addContextType(CONTEXT_MXML_TYPE_ID);
		}
		return mxmlContextRegistry;
	}

	public ContextTypeRegistry getCotextDescriptorTypeRegistry() {
		if (descriptorContextRegistry == null) {
			descriptorContextRegistry = new ContributionContextTypeRegistry();
			descriptorContextRegistry.addContextType(CONTEXT_DESCRIPTOR_TYPE_ID);
		}
		return descriptorContextRegistry;
	}

}
