package net.sf.amateras.air.as;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;

/**
 * Strategy to which selection is delimited by ":" when double-clicking it.
 * @author hideko ogawa
 */
public class ActionScriptDoubleClickStrategy extends DefaultTextDoubleClickStrategy {

	@Override
	public void doubleClicked(ITextViewer text) {
		int pos = text.getSelectedRange().x;
		super.doubleClicked(text);
		Point point = text.getSelectedRange();
		if (point != null && point.x != point.y) {
			IDocument document = text.getDocument();

			try {
				String t = document.get(point.x, point.y);
				int p = t.indexOf(":");
				if (p > 0) {
					if (pos <= p + point.x) {
						text.setSelectedRange(point.x, p);
					} else {
						text.setSelectedRange(p + point.x + 1, t.length() - p - 1);
					}
				}
			} catch (BadLocationException e) {
				e.printStackTrace();
			}
			try {
				String t = document.get(point.x, point.y);
				int p = t.indexOf(".");
				if (p > 0) {
					if (pos <= p + point.x) {
						text.setSelectedRange(point.x, p);
					} else {
						text.setSelectedRange(p + point.x + 1, t.length() - p - 1);
					}
				}
			} catch (BadLocationException e) {
				e.printStackTrace();
			}

		}
	}
}
