package net.sf.amateras.air.as.syntax;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class SyntaxContextInformationValidator implements IContextInformationValidator, IContextInformationPresenter {

	private int textStartPos;
	private int textEndPos;

	public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
		textEndPos = documentPosition;
		textStartPos = documentPosition - info.getInformationDisplayString().length();
	}

	public boolean isContextInformationValid(int documentPosition) {
		if (((documentPosition - textStartPos) <= 0) || documentPosition > textEndPos) {
			return false;
		}

		return true;
	}

	public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
		return false;
	}
}
