package net.sf.amateras.air.as.syntax.analyze;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.CompileProperty;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ProjectAnalizer extends AbstractClassAnalizer {

	@Override
	protected IResource[] getParentPath(IProject project) {
		List<IResource> work = new ArrayList<IResource>();
		ScopedPreferenceStore store = new ScopedPreferenceStore(new ProjectScope(project), AIRPlugin.PLUGIN_ID);
		final List<CompileProperty> compiles = CompileProperty.load(store);
		for (CompileProperty compile : compiles) {
			String directory = compile.getDirectory();
			if (directory == null || directory.length() == 0) {
				work.add(project);
			} else {
				IFolder folder = project.getFolder(directory);
				work.add(folder);
			}
		}
		return work.toArray(new IResource[work.size()]);
	}

}
