package net.sf.amateras.air.as.syntax.analyze;

import java.util.List;

import net.sf.amateras.air.as.syntax.PreviousWord;
import net.sf.amateras.air.templates.ActionScriptTemplateCompletionProcessor;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class TemplateAnalizer {

	public void addSyntaxClass(int documentOffset, PreviousWord previousWord, List<ICompletionProposal> result,
			ITextViewer viewer) {
		if (previousWord.getPreviousWord().length() <= 0) {
			return;
		}
		if (previousWord.getType() != PreviousWord.TYPE_ALL) {
			return;
		}

		ActionScriptTemplateCompletionProcessor templateProcessor = new ActionScriptTemplateCompletionProcessor();
		ICompletionProposal[] templateProposals = templateProcessor.computeCompletionProposals(viewer, documentOffset);
		for (ICompletionProposal prop : templateProposals) {
			result.add(prop);
		}
	}

}
