package net.sf.amateras.air.builder;

import java.io.File;
import java.io.IOException;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleManager;

/**
 * fcsh shell process for air builder.
 * @author hideko ogawa
 *
 */
@SuppressWarnings("restriction")
public class FcshShell implements IStreamListener {

	private static final int WAIT_MILLIS = 100;
	private Process process;
	private int workedIndex;
	private IProcess proc;
	private ProcessConsole console;
	private IProgressMonitor monitor;
	private boolean isFcshProcessEnd;
	private StringBuilder sb;

	/**
	 * Start fsch.
	 * 
	 * @param dir the current directory of fsch.
	 * @throws IOException
	 */
	public void startShell(File dir, IProgressMonitor monitor) throws IOException {
		this.monitor = monitor;
		sb = new StringBuilder();
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String path = store.getString(AIRPlugin.PREF_FCSH_SHELL_COMMAND);
		String sdkPath = ProcessUtil.getAirSdkPath(path);

		File fcsh = new File(sdkPath, path);

		monitor.setTaskName(AIRPlugin.getResourceString("COMPILE_START_SHELL"));

		process = ProcessUtil.createProcess(fcsh, dir);
		proc = DebugPlugin.newProcess(new Launch(null, ILaunchManager.RUN_MODE, null), process, "fcsh console ["
				+ dir.getName() + "]");
		console = new ProcessConsole(proc, new ConsoleColorProvider());
		console.addPropertyChangeListener(new IPropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent event) {
				if (event.getProperty().equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
					stopShell();
				}
			}
		});

		IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
		manager.addConsoles(new IConsole[] { console });
		manager.showConsoleView(console);

		waitFcshProcessEnd();
		this.monitor = null;
	}

	public void streamAppended(String text, IStreamMonitor monitor) {
		//		System.out.println(text);
		sb.append(text);
		if (text.indexOf("(fcsh)") >= 0) {
			isFcshProcessEnd = true;
		}
	}

	private void waitFcshProcessEnd() {
		isFcshProcessEnd = false;
		proc.getStreamsProxy().getOutputStreamMonitor().addListener(this);
		proc.getStreamsProxy().getErrorStreamMonitor().addListener(this);

		while (!isFcshProcessEnd) {
			try {
				Thread.sleep(WAIT_MILLIS);

			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
		//		System.out.println("end...");
	}

	//	private MessageConsoleStream createConsoleStream() {
	//		MessageConsole console = new MessageConsole("fcsh console", null);
	//		MessageConsoleStream stream = console.newMessageStream();
	//
	//		IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
	//		manager.addConsoles(new IConsole[] { console });
	//		manager.showConsoleView(console);
	//		return stream;
	//	}

	public String startCommand(String command, IProgressMonitor monitor) {
		this.monitor = monitor;
		sb = new StringBuilder();
		System.out.println(command);
		sb.append(command);
		console.getInputStream().appendData(command);

		monitor.internalWorked(workedIndex++);

		waitFcshProcessEnd();
		this.monitor = null;
		return sb.toString();

	}

	/**
	 * return fcsh process
	 * @return
	 */
	public Process getProcess() {
		return process;
	}

	/**
	 * Shutdown fsch.
	 */
	public void stopShell() {

		isFcshProcessEnd = true;
		if (monitor != null) {
			monitor.setCanceled(true);
			monitor = null;
		}
		if (console != null) {
			console.destroy();
			console = null;
		}
		if (proc != null) {
			try {
				proc.terminate();
			} catch (DebugException e) {
				DebugPlugin.log(e);
			}
		}

		if (process != null) {
			process.destroy();
			process = null;
			System.out.println(" stop Shell");
		}
	}

	public void setWorkdIndex(int index) {
		this.workedIndex = index;
	}
}
