package net.sf.amateras.air.debug;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;

/**
 * LineBreakPoint for AIR GEAR.
 * @author hideko ogawa
 */
public class AirLineBreakPoint extends LineBreakpoint {
	public static final String BREAK_POINT_MARKER = "net.sf.amateras.air.debug.markerType.lineBreakpoint";
	public static final String BREAK_POINT = "net.sf.amateras.air.debug.lineBreakpoint";
	public static final String DEBUG_MODEL_IDENTIFIER = "net.sf.amateras.air.debug";
	public static final String WATCH_POINT = "net.sf.amateras.air.debug.markerType.watchpoint";

	private boolean fdbAppended = false;

	public void addBreakPointManager(IResource resource, int lineNumber) throws CoreException {
		Map<String, Object> map = new HashMap<String, Object>(6);
		addLineBreakpointAttributes(map, lineNumber);

		IMarker marker;
		marker = resource.createMarker(AirLineBreakPoint.BREAK_POINT_MARKER);
		marker.setAttributes(map);
		setMarker(marker);

		IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
		breakpointManager.addBreakpoint(this);
	}

	public String getModelIdentifier() {
		return DEBUG_MODEL_IDENTIFIER;
	}

	private void addLineBreakpointAttributes(Map<String, Object> attributes, int lineNumber) {
		attributes.put(IMarker.MESSAGE, "AIR GEAR - BREAK POINT");
		attributes.put(IBreakpoint.ID, BREAK_POINT);
		attributes.put(IMarker.LINE_NUMBER, new Integer(lineNumber));
		attributes.put(IBreakpoint.PERSISTED, Boolean.TRUE);
		attributes.put(IBreakpoint.ENABLED, Boolean.TRUE);
		attributes.put(IBreakpoint.REGISTERED, Boolean.FALSE);
	}

	public boolean isFdbAppended() {
		return fdbAppended;
	}

	public void setFdbAppended(boolean fdbAppended) {
		this.fdbAppended = fdbAppended;
	}

}
