package net.sf.amateras.air.debug.debugger;

import java.io.File;
import java.io.IOException;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleManager;

/**
 * 
 * @author hideko ogawa
 */
@SuppressWarnings("restriction")
public class FdbGateway {

	private Process process;
	private IProcess proc;
	private ProcessConsole console;

	/**
	 * Start fdb.
	 * @throws IOException CoreException
	 */
	public void start() throws IOException {
		createProcess();
		addConsole();
	}

	private void createProcess() throws IOException {
		String fdbCommand = AIRPlugin.getDefault().getPreferenceStore().getString(AIRPlugin.PREF_FDB_COMMAND);
		String sdkPath = ProcessUtil.getAirSdkPath(fdbCommand);
		File fcsh = new File(sdkPath, fdbCommand);
		process = ProcessUtil.createProcess(fcsh, null);
		proc = DebugPlugin.newProcess(new Launch(null, ILaunchManager.DEBUG_MODE, null), process, "fdb console");

	}

	private void addConsole() {
		console = new ProcessConsole(proc, new ConsoleColorProvider());
		console.addPropertyChangeListener(new IPropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent event) {
				if (event.getProperty().equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
					stopShell();
				}
			}
		});
		IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
		manager.addConsoles(new IConsole[] { console });
		manager.showConsoleView(console);
	}

	public void addOutputStreamListener(IStreamListener stream) {
		proc.getStreamsProxy().getOutputStreamMonitor().addListener(stream);
		proc.getStreamsProxy().getErrorStreamMonitor().addListener(stream);
	}

	public void removeOutputStreamListener(IStreamListener stream) {
		proc.getStreamsProxy().getOutputStreamMonitor().removeListener(stream);
		proc.getStreamsProxy().getErrorStreamMonitor().removeListener(stream);
	}

	/**
	 * send request to fdb
	 * @param text
	 * @return response
	 */
	public void sendRequest(String text) {
		if (console == null) {
			return;
		}
		//System.out.println("FdbShell#sendRequest(" + text + ")");
		console.getInputStream().appendData(text + "\n");
	}

	/**
	 * return fdb process
	 * @return
	 */
	public Process getProcess() {
		return process;
	}

	/**
	 * return fdb IProcess
	 * @return
	 */
	public IProcess getIProcess() {
		return proc;
	}

	/**
	 * Shutdown fdb.
	 */
	public void stopShell() {
		System.out.println("FdbShell#stopShell");
		if (console != null) {
			IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
			console.destroy();
			manager.removeConsoles(new IConsole[] { console });
			console = null;
		}
		if (proc != null) {
			try {
				proc.terminate();
			} catch (DebugException e) {
				DebugPlugin.log(e);
			}
		}

		if (process != null) {
			process.destroy();
			process = null;
		}
		System.out.println(" stop Shell");
	}

	public void clearProcess() {
		process = null;
	}
}
