package net.sf.amateras.air.debug.watch;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class ExpressionMatchResult implements IWatchExpressionResult {

	private String[] errorMessages;
	private DebugException exception;
	private String exceptionText;
	private IValue value;

	public ExpressionMatchResult(IValue value) {
		this.value = value;
	}

	public String[] getErrorMessages() {
		return errorMessages;
	}

	public void setErrorMessage(String[] messages) {
		this.errorMessages = messages;
	}

	public DebugException getException() {
		return exception;
	}

	public void setException(DebugException exception) {
		this.exception = exception;
	}

	public String getExpressionText() {
		return exceptionText;
	}

	public void setExpressionText(String text) {
		this.exceptionText = text;
	}

	public IValue getValue() {
		return value;
	}

	public void setValue(IValue value) {
		this.value = value;
	}

	public boolean hasErrors() {
		return false;
	}

}
