package net.sf.amateras.air.debug.watch;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

/**
 * Action that adds Expression from editor.
 * @author hideko ogawa
 *
 */
public class WatchExpressionAction implements IEditorActionDelegate {
	private ITextSelection selection;

	public void setActiveEditor(IAction action, IEditorPart targetEditor) {

	}

	public void run(IAction action) {
		if (selection == null) {
			return;
		}
		String text = selection.getText();
		createExpression(text);
	}

	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = null;
		if (selection instanceof ITextSelection) {
			this.selection = (ITextSelection) selection;
		}
	}

	private void showExpressionsView() {
		IWorkbenchPage page = AIRPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
		IViewPart part = page.findView(IDebugUIConstants.ID_EXPRESSION_VIEW);
		if (part == null) {
			try {
				page.showView(IDebugUIConstants.ID_EXPRESSION_VIEW);
			} catch (PartInitException e) {
				AIRPlugin.logException(e);
			}
		} else {
			page.bringToTop(part);
		}
	}

	private void createExpression(String variable) {

		//		IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager()
		//				.newWatchExpression(variable);
		IWatchExpression expression = new AirWatchExpression(variable);

		DebugPlugin.getDefault().getExpressionManager().addExpression(expression);
		IAdaptable object = DebugUITools.getDebugContext();
		IDebugElement context = null;
		if (object instanceof IDebugElement) {
			context = (IDebugElement) object;
		} else if (object instanceof ILaunch) {
			context = ((ILaunch) object).getDebugTarget();
		}
		expression.setExpressionContext(context);
		showExpressionsView();
	}
}
