package net.sf.amateras.air.launch;

import java.io.File;
import java.io.IOException;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.AirBuilderManager;
import net.sf.amateras.air.builder.CompileProperty;
import net.sf.amateras.air.debug.AirDebugTarget;
import net.sf.amateras.air.util.ProcessUtil;
import net.sf.amateras.air.util.UIUtil;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/**
 * launch air application.
 * 
 * @author ogawahideko
 *
 */
@SuppressWarnings("restriction")
public class LaunchAIRConfiguration extends LaunchConfigurationDelegate implements IDebugEventSetListener {

	public static final String ID = "net.sf.amateras.air.launchAIRConfigurationType";

	public void handleDebugEvents(DebugEvent[] events) {
	}

	@Override
	protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
		return new IProject[] { getProject(configuration) };
	}

	@Override
	protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor)
			throws CoreException {

		if (ILaunchManager.DEBUG_MODE.equals(mode)) {
			monitor.subTask("debug compile");
			prepareDebugExecution(configuration);
		}
		return super.saveBeforeLaunch(configuration, mode, monitor);
	}

	private IProject getProject(ILaunchConfiguration configuration) throws CoreException {
		String projectName = configuration.getAttribute(LaunchAIRMainTab.ATTR_PROJECT, "");
		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		return project;
	}

	/**
	 * 
	 * @param configuration
	 * @throws CoreException
	 */
	private void prepareDebugExecution(ILaunchConfiguration configuration) throws CoreException {
		IProject project = getProject(configuration);
		ScopedPreferenceStore store = new ScopedPreferenceStore(new ProjectScope(project), AIRPlugin.PLUGIN_ID);
		List<CompileProperty> compiles = CompileProperty.load(store);
		boolean isChanged = false;

		for (CompileProperty prop : compiles) {
			String option = prop.getOption();
			if (option.indexOf("-debug=true") == -1) {
				isChanged = true;
				prop.setOption(option + " -debug=true");
			}
		}

		if (isChanged) {
			UIUtil.openMessageDialog(AIRPlugin.getResourceString("SET_DEBUG_OPTION"));
			CompileProperty.save(store, compiles);
			WorkbenchPlugin.getDefault().getDecoratorManager().updateForEnablementChange();
			AirBuilderManager.doClean(project);
		}
	}

	/**
	 * launch Air Application
	 */
	public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor)
			throws CoreException {

		String projectName = configuration.getAttribute(LaunchAIRMainTab.ATTR_PROJECT, "");
		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);

		// get target descriptor.
		String target;
		boolean isEnableDescriptorEx = LaunchAIRMainTab.isEnableDescriptorEx(configuration);
		if (isEnableDescriptorEx) {
			target = configuration.getAttribute(LaunchAIRMainTab.ATTR_TARGET, "");
		} else {
			target = LaunchAIRMainTab.getProjectDescriptor(project);
		}

		if (new File(target).exists()) {
			target = new File(target).getAbsolutePath();
		} else {
			IFile targetFile = project.getFile(new Path(target));
			target = targetFile.getLocation().toString();
		}

		if (!ProcessUtil.checkAirGearProject(project)) {
			return;
		}

		// get 'sdkPath'
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String adlpath = store.getString(AIRPlugin.PREF_ADL_COMMAND);
		String sdkPath = ProcessUtil.getAirSdkPath(adlpath);

		if (sdkPath == null) {
			return;
		}

		try {
			//			File executeFile = new File(sdkPath, adlpath);
			//			String[] command = new String[] { target };
			//			Process process = ProcessUtil.createProcess(executeFile, command, null);
			//			IProcess newProcess = DebugPlugin.newProcess(launch, process, "\""
			//					+ executeFile.getName() + " " + new File(command[0]).getName());
			//System.out.println("mode=" + mode);

			// if in debug mode, create a debug target 
			if (ILaunchManager.DEBUG_MODE.equals(mode)) {
				if (AirDebugTarget.isAlreadyInstance()) {
					launch.terminate();
					UIUtil.openMessageDialog(AIRPlugin.getResourceString("IS_ALREADY_STARTING"));
					return;
				} else {
					IDebugTarget debugTarget = new AirDebugTarget(launch, target);
					launch.addDebugTarget(debugTarget);
				}

			} else {
				File executeFile = new File(sdkPath, adlpath);
				String[] command = new String[] { target };
				Process process = ProcessUtil.createProcess(executeFile, command, null);
				DebugPlugin.newProcess(launch, process, "\"" + executeFile.getName() + " "
						+ new File(command[0]).getName());
			}

		} catch (IOException ex) {
			AIRPlugin.logException(ex);
		}

		//		ADLRunner runner = new ADLRunner();
		//		runner.run(new File(sdkPath, adlpath), new String[] { target }, launch, monitor);
	}

}
