package net.sf.amateras.air.mxml.action;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.VisualMXMLEditor;
import net.sf.amateras.air.mxml.editparts.command.CreateCommand;
import net.sf.amateras.air.mxml.models.AbstractContainerModel;
import net.sf.amateras.air.mxml.models.CanvasModel;
import net.sf.amateras.air.mxml.models.FlexRectangle;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;

/**
 * add Canvas to ContainerFigure.
 * @author ogawahideko
 *
 */
public class AddCanvasAction extends MXMLEditorAction {
	private AbstractContainerModel selectedModel;

	public AddCanvasAction(VisualMXMLEditor editor) {
		super(AIRPlugin.getResourceString("ADD_CANVAS"), editor);
		setImageDescriptor(AIRPlugin.getImageDescriptor("icons/canvas.gif"));
	}

	@Override
	public void run() {
		if (selectedModel == null) {
			return;
		} else {
			InputDialog input = new InputDialog(Display.getDefault().getActiveShell(), "", AIRPlugin
					.getResourceString("ENTRY_TITLE"), null, null);
			if (input.open() == InputDialog.CANCEL) {
				return;
			}
			String title = input.getValue();
			CanvasModel model = new CanvasModel(title);
			FlexRectangle rec = new FlexRectangle();
			rec.setStrWidth("100%");
			rec.setStrHeight("100%");
			CreateCommand command = new CreateCommand(selectedModel, model, rec);
			getCommandStack().execute(command);
		}
	}

	public void setContainerModel(AbstractContainerModel selectedModel) {
		this.selectedModel = selectedModel;
	}

	@Override
	public void update(IStructuredSelection selection) {
		// Nothing todo.
	}

}
