package net.sf.amateras.air.mxml.action;

import net.sf.amateras.air.mxml.VisualMXMLEditor;
import net.sf.amateras.air.mxml.editparts.AbstractComponentEditPart;
import net.sf.amateras.air.mxml.models.AbstractComponentModel;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Move up the selected component in the {@link VisualMXMLEditor}.
 * 
 * @author Naoki Takezoe
 */
public class MoveUpAction extends MXMLEditorAction {

	private AbstractComponentModel model;

	public MoveUpAction(VisualMXMLEditor editor) {
		super("Move Up", editor);
	}

	@Override
	public void run() {
		final AbstractComponentModel execModel = model;
		getCommandStack().execute(new Command() {
			@Override
			public void execute() {
				execModel.moveUp();
				updateEnable(execModel);
				editor.getMenuFactory().getMoveDownAction().updateEnable(execModel);
			}

			@Override
			public void undo() {
				execModel.moveDown();
				updateEnable(execModel);
				editor.getMenuFactory().getMoveDownAction().updateEnable(execModel);
			}
		});
	}

	@Override
	public void update(IStructuredSelection selection) {
		Object obj = selection.getFirstElement();
		if (obj != null && obj instanceof AbstractComponentEditPart) {
			if (((EditPart) obj).getModel() instanceof AbstractComponentModel) {
				updateEnable((AbstractComponentModel) ((EditPart) obj).getModel());
				return;
			}
		}
		setEnabled(false);
		this.model = null;
	}

	public void updateEnable(AbstractComponentModel model) {
		if (model != null) {
			boolean isEnabled = model.isMoveUpEnabled();
			if (isEnabled) {
				setEnabled(isEnabled);
				this.model = model;
				return;
			}
		}
		this.model = null;
		setEnabled(false);
	}

}
