package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.ComponentImageRegistry;
import net.sf.amateras.air.mxml.descriptor.editor.StringColorCellEditor;
import net.sf.amateras.air.mxml.models.AbstractModel;
import net.sf.amateras.air.util.ColorUtil;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;

/**
 * Descriptor for value of Color(RGB).
 * 
 * @author ogawahideko
 */
public class ColorChoosePropertyDescriptor extends ColorPropertyDescriptor implements IEditorValueDescriptor<Object> {

	private RGB defaultValue;

	public ColorChoosePropertyDescriptor(Object id, String displayName, RGB defaultValue) {
		super(id, displayName);
		this.defaultValue = defaultValue;
		setLabelProvider(new MyLabelDecorator());
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public Object getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public Object getEditorValue(Object value) {
		if (value != null) {
			return value;
		} else if (defaultValue != null) {
			return defaultValue;
		} else {
			return null;
		}
	}

	class MyLabelDecorator extends PropertyLabelDecoratorUtil {
		@Override
		public Image getImage(Object element) {
			if (element != AbstractModel.NULL_PROPERTY && element != defaultValue) {
				return ComponentImageRegistry.getSetPropertyImage();
			} else {
				return null;
			}
		}

		@Override
		protected String getTextString(Object element) {
			if (element != null && element instanceof RGB) {
				return ColorUtil.toHex((RGB) element);
			} else {
				return super.getTextString(element);
			}
		}
	}

	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor editor = new StringColorCellEditor(parent);
		//CellEditor editor = new ColorCellEditor(parent);
		//if (getValidator() != null) {
		//	editor.setValidator(getValidator());
		//}
		return editor;
	}

}
