package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.descriptor.editor.ImageDialogCellEditor;
import net.sf.amateras.air.mxml.models.AbstractModel;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * <code>PropertyDescriptor</code> for the image property.
 * 
 * @author Naoki Takezoe
 */
public class ImagePropertyDescriptor extends PropertyDescriptor implements IEditorValueDescriptor<String> {

	private String defaultValue;

	public ImagePropertyDescriptor(Object id, String displayName, String defaultValue) {
		super(id, displayName);
		this.defaultValue = defaultValue;
		setLabelProvider(new PropertyLabelDecoratorUtil(defaultValue));
	}

	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		DialogCellEditor cellEditor = new ImageDialogCellEditor(parent);
		return cellEditor;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getEditorValue(String value) {
		if (value != null && value.length() != 0) {
			return value;
		} else if (defaultValue != null) {
			return defaultValue;
		} else {
			return AbstractModel.NULL_PROPERTY;
		}
	}

	class MyLabelDecorator extends PropertyLabelDecoratorUtil {
		@Override
		protected String getDefaultValue() {
			if (defaultValue == null) {
				return AbstractModel.NULL_PROPERTY;
			} else {
				return defaultValue.toString();
			}
		}
	}
}
