package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.models.AbstractModel;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * Descriptor for width,height.
 * use number or %.
 * 
 * @author ogawahideko
 *
 */
public class WidthHeightPropertyDescriptor extends TextPropertyDescriptor implements IEditorValueDescriptor<String> {

	private String defaultValue;

	public WidthHeightPropertyDescriptor(Object id, String displayName, String defaultValue) {
		super(id, displayName);
		setValidator(new WidhtHeightValidator());
		this.defaultValue = defaultValue;
		setLabelProvider(new PropertyLabelDecoratorUtil(defaultValue));
	}

	class WidhtHeightValidator implements ICellEditorValidator {
		public String isValid(Object value) {
			if (value != null && value.toString().length() > 0) {
				char[] charArray = value.toString().toCharArray();
				for (int i = 0; i < charArray.length; i++) {
					if (!Character.isDigit(charArray[i])) {
						if (i == charArray.length - 1) {
							// last char
							if (charArray[i] == '%') {
								continue;
							}
						}
						return "The input value is not a numerical value. ";
					}
				}
				return null;
			}
			return null;
		}
	}

	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor editor = new WidthHeightCellEditor(parent);
		if (getValidator() != null) {
			editor.setValidator(getValidator());
		}
		return editor;
	}

	class WidthHeightCellEditor extends TextCellEditor {
		WidthHeightCellEditor(Composite parent) {
			super(parent);
		}

		@Override
		protected void doSetValue(Object value) {
			if (value == null) {
				text.setText(AbstractModel.NULL_PROPERTY);
			} else {
				Assert.isTrue(text != null);
				text.setText(String.valueOf(value));
			}

		}

		@Override
		protected Object doGetValue() {
			String value = text.getText();
			if (value == null || value.length() == 0) {
				return AbstractModel.NULL_PROPERTY;
			} else {
				return value;
			}
		}
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getEditorValue(String value) {
		if (value != null && value.length() != 0) {
			return value;
		} else {
			return defaultValue;
		}
	}

}
