package net.sf.amateras.air.mxml.descriptor.editor;

import net.sf.amateras.air.mxml.models.AbstractModel;
import net.sf.amateras.air.util.UIUtil;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ImageDialogCellEditor extends AbstractTextDialogCellEditor {

	public static final String CELL_EDITOR_IMG_DOTS_BUTTON = "cell_editor_dots_button_image";//$NON-NLS-1$

	public ImageDialogCellEditor(Composite parent) {
		super(parent);
	}

	@Override
	protected Object getDefaultValue() {
		return "";
	}

	@Override
	protected Object openDialogBox(Control cellEditorWindow) {
		try {
			IEditorPart editorPart = UIUtil.getActiveEditor();
			IFileEditorInput input = (IFileEditorInput) editorPart.getEditorInput();
			IProject project = input.getFile().getProject();

			ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getShell(), new WorkbenchLabelProvider(),
					new WorkbenchContentProvider());

			dialog.setInput(ResourcesPlugin.getWorkspace());
			dialog.addFilter(new ViewerFilter() {
				@Override
				public boolean select(Viewer viewer, Object parentElement, Object element) {
					if (element instanceof IProject || element instanceof IFolder) {
						return true;
					}
					if (element instanceof IFile) {
						String name = ((IFile) element).getName();
						if (name.endsWith(".png") || name.endsWith(".gif") || name.endsWith(".jpg")
								|| name.endsWith(".jpeg")) {
							return true;
						}
					}
					return false;
				}
			});
			dialog.setAllowMultiple(false);
			dialog.setTitle("Icon");
			dialog.setInput(project);

			if (dialog.open() == ResourceSelectionDialog.OK) {
				String path = "";
				int count = input.getFile().getProjectRelativePath().segmentCount() - 1;
				for (int i = 0; i < count; i++) {
					path = path + "../";
				}
				path = path + ((IFile) dialog.getResult()[0]).getProjectRelativePath().toString();

				return "@Embed('" + path + "')";
			}

			return AbstractModel.NULL_PROPERTY;
		} finally {
			text.setEnabled(true);
		}
	}

	@Override
	protected void updateContents(Object value) {
		if (text == null) {
			return;
		}
		String setValue = "";//$NON-NLS-1$
		if (value != null) {
			setValue = value.toString();
		}
		text.setText(setValue);
	}

}
