package net.sf.amateras.air.mxml.descriptor.editor;

import net.sf.amateras.air.util.ColorUtil;

import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StringColorCellEditor extends AbstractTextDialogCellEditor {

	private static final int DEFAULT_EXTENT = 16;

	private static final RGB DEFAULT_RGB = new RGB(0, 0, 0);

	private Image image;

	public StringColorCellEditor(Composite parent) {
		super(parent);
	}

	@Override
	protected Object getDefaultValue() {
		return DEFAULT_RGB;
	}

	private ImageData createColorImage(Control w, RGB color) {
		GC gc = new GC(w);
		FontMetrics fm = gc.getFontMetrics();
		int size = fm.getAscent();
		gc.dispose();

		int indent = 6;
		int extent = DEFAULT_EXTENT;

		if (size > extent) {
			size = extent;
		}

		int width = indent + size;
		int height = extent;

		int xoffset = indent;
		int yoffset = (height - size) / 2;

		RGB black = DEFAULT_RGB;
		PaletteData dataPalette = new PaletteData(new RGB[] { black, black, color });
		ImageData data = new ImageData(width, height, 4, dataPalette);
		data.transparentPixel = 0;

		int end = size - 1;
		for (int y = 0; y < size; y++) {
			for (int x = 0; x < size; x++) {
				if (x == 0 || y == 0 || x == end || y == end) {
					data.setPixel(x + xoffset, y + yoffset, 1);
				} else {
					data.setPixel(x + xoffset, y + yoffset, 2);
				}
			}
		}

		return data;
	}

	@Override
	public void dispose() {
		if (image != null) {
			image.dispose();
			image = null;
		}
		super.dispose();
	}

	@Override
	protected Object openDialogBox(Control cellEditorWindow) {
		text.setEnabled(false);
		try {
			ColorDialog dialog = new ColorDialog(cellEditorWindow.getShell());
			Object value = getValue();
			if (value != null) {
				if (value instanceof RGB) {
					dialog.setRGB((RGB) value);
				} else {
					dialog.setRGB(ColorUtil.toRGB(value.toString()));
				}
			}
			value = dialog.open();
			return dialog.getRGB();
		} finally {
			text.setEnabled(true);
		}
	}

	@Override
	protected void updateContents(Object value) {
		RGB rgb = null;
		if (value instanceof RGB) {
			rgb = (RGB) value;
			String t = ColorUtil.toHex(rgb);
			text.setText(t);
		} else if (value != null && value.toString().length() > 0) {
			text.setText(value.toString());
			rgb = ColorUtil.toRGB(value.toString());
		} else {
			text.setText("");
		}
		if (rgb == null) {
			rgb = DEFAULT_RGB;
		}
		if (image != null) {
			image.dispose();
		}

		ImageData id = createColorImage(imageLabel.getParent().getParent(), rgb);
		ImageData mask = id.getTransparencyMask();
		image = new Image(imageLabel.getDisplay(), id, mask);
		imageLabel.setImage(image);
	}
}
