package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.LabelFigure;
import net.sf.amateras.air.mxml.models.LabelModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link LabelModel}.
 * 
 * @author Naoki Takezoe
 */
public class LabelEditPart extends AbstractDirectEditPart {

	@Override
	protected IFigure createFigure() {
		LabelFigure label = new LabelFigure();
		label.setOpaque(true);
		label.setLabelAlignment(Label.LEFT);
		updateFigure(label, (LabelModel) getModel());
		return label;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((Label) getFigure(), (LabelModel) getModel());
	}

	private void updateFigure(Label label, LabelModel model) {
		label.setToolTip(new Label(model.toString()));
		label.setText(model.getAttributeToString(LabelModel.TEXT));
		AIRPlugin.getDefault().getFontManager().setFont(model, label);
		setTextDecoration(model, label);

		label.repaint();
	}

	@Override
	protected String getDirectEditPropertyKey() {
		return LabelModel.TEXT;
	}

}
