package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.LabelFigure;
import net.sf.amateras.air.mxml.models.DateFieldModel;
import net.sf.amateras.air.mxml.models.LinkButtonModel;
import net.sf.amateras.air.util.ColorUtil;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;

/**
 * The editpart for the {@link DateFieldModel}.
 * 
 * @author ogawahideko
 */
public class LinkButtonEditPart extends AbstractDirectEditPart {
	private String oldIcon = "";

	@Override
	protected IFigure createFigure() {
		LabelFigure figure = new LabelFigure();
		figure.setLabelAlignment(Label.CENTER);
		figure.setBorder(new LineBorder(ColorConstants.lightGray));
		updateFigure(figure, (LinkButtonModel) getModel());
		return figure;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((LabelFigure) getFigure(), (LinkButtonModel) getModel());
	}

	private void updateFigure(LabelFigure figure, LinkButtonModel model) {
		figure.setToolTip(new Label(model.toString()));
		figure.setText(model.getAttributeToString(LinkButtonModel.LABEL));

		// icon
		if (!model.getAttributeToString(LinkButtonModel.ICON).equals(oldIcon)) {
			oldIcon = (String) model.getAttribute(LinkButtonModel.ICON);
			figure.setIcon(getEmbedResourceAsImage(oldIcon));
		}

		// font
		AIRPlugin.getDefault().getFontManager().setFont(model, figure);

		//TextDecoration
		setTextDecoration(model, figure);

		//backGroundColor
		if (model.getAttribute(LinkButtonModel.FILL_COLORS) != null) {
			String value = model.getAttributeToString(LinkButtonModel.FILL_COLORS);

			value = value.replaceAll("0x", "#");
			if (value.length() > 0) {
				value = value.substring(1, 8);
				figure.setBackgroundColor(getColor(ColorUtil.toRGB(value)));
			}
		}

	}

	@Override
	protected String getDirectEditPropertyKey() {
		return LinkButtonModel.LABEL;
	}

}
